/*
 * Decompiled with CFR 0.152.
 */
package xapi.model.impl;

import xapi.annotation.inject.SingletonDefault;
import xapi.collect.X_Collect;
import xapi.collect.api.StringTo;
import xapi.model.api.Model;
import xapi.model.service.ModelCache;
import xapi.util.api.SuccessHandler;

@SingletonDefault(implFor=ModelCache.class)
public class AbstractModelCache
implements ModelCache {
    StringTo<Model> models = X_Collect.newStringMap(Model.class);

    @Override
    public Model getModel(String key) {
        return (Model)this.models.get(key);
    }

    @Override
    public void cacheModel(Model model, SuccessHandler<Model> callback) {
        this.models.put(model.getKey().toString(), (Object)model);
        callback.onSuccess((Object)model);
    }

    @Override
    public void saveModel(Model model, SuccessHandler<Model> callback) {
        this.models.put(model.getKey().toString(), (Object)model);
        callback.onSuccess((Object)model);
    }

    @Override
    public void deleteModel(Model model, SuccessHandler<Model> callback) {
        this.models.remove(model.getKey().toString());
        callback.onSuccess((Object)model);
    }
}

