/*
 * Decompiled with CFR 0.152.
 */
package xapi.model.api;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Objects;
import xapi.collect.X_Collect;
import xapi.collect.api.IntTo;
import xapi.collect.api.StringTo;
import xapi.dev.source.CharBuffer;
import xapi.inject.X_Inject;
import xapi.model.X_Model;
import xapi.model.api.Model;
import xapi.model.api.ModelManifest;
import xapi.model.api.PrimitiveSerializer;
import xapi.model.impl.ClusteringPrimitiveDeserializer;
import xapi.model.impl.ClusteringPrimitiveSerializer;
import xapi.source.api.CharIterator;
import xapi.source.impl.StringCharIterator;
import xapi.util.X_Debug;
import xapi.util.api.Digester;

public class ModelModule
implements Serializable {
    private static final long serialVersionUID = 977462783892289984L;
    private final StringTo<ModelManifest> manifests = X_Collect.newStringMap(ModelManifest.class);
    private final IntTo<String> strongNames = X_Collect.newList(String.class);
    private String uuid;
    private String moduleName;
    private transient String serialized;

    public ModelModule addManifest(ModelManifest manifest) {
        this.manifests.put(manifest.getType(), (Object)manifest);
        return this;
    }

    public ModelModule addStrongName(String strongName) {
        this.strongNames.add((Object)strongName);
        return this;
    }

    public ModelManifest getManifest(String modelType) {
        return (ModelManifest)this.manifests.get(modelType);
    }

    public String[] getStrongNames() {
        return (String[])this.strongNames.toArray();
    }

    public String getUuid() {
        if (this.uuid == null) {
            this.uuid = this.computeUuid((PrimitiveSerializer)X_Inject.instance(PrimitiveSerializer.class));
        }
        return this.uuid;
    }

    protected String computeUuid(PrimitiveSerializer primitives) {
        byte[] asBytes;
        String result = this.calculateSerialization(primitives);
        Digester digest = (Digester)X_Inject.instance(Digester.class);
        try {
            asBytes = result.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw X_Debug.rethrow((Throwable)e);
        }
        byte[] uuid = digest.digest(asBytes);
        return digest.toString(uuid);
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public static String serialize(ModelModule module) {
        CharBuffer buffer = new CharBuffer();
        ModelModule.serialize(buffer, module, (PrimitiveSerializer)X_Inject.instance(PrimitiveSerializer.class));
        return buffer.toString();
    }

    public static CharBuffer serialize(CharBuffer into, ModelModule module, PrimitiveSerializer primitives) {
        into.append(primitives.serializeString(module.getUuid()));
        into.append(primitives.serializeInt(module.strongNames.size()));
        for (String strongName : module.strongNames.forEach()) {
            into.append(primitives.serializeString(strongName));
        }
        into.append(module.calculateSerialization(primitives));
        return into;
    }

    protected String calculateSerialization(PrimitiveSerializer primitives) {
        if (this.serialized != null) {
            return this.serialized;
        }
        CharBuffer policy = new CharBuffer();
        policy.append(primitives.serializeString(this.getModuleName()));
        primitives = new ClusteringPrimitiveSerializer(primitives, policy);
        policy.append(primitives.serializeInt(this.manifests.size()));
        for (ModelManifest manifest : this.manifests.values()) {
            ModelManifest.serialize(policy, manifest, primitives);
        }
        this.serialized = policy.toString();
        return this.serialized;
    }

    public static ModelModule deserialize(String chars) {
        StringCharIterator iter = new StringCharIterator(chars);
        return ModelModule.deserialize((CharIterator)iter, (PrimitiveSerializer)X_Inject.instance(PrimitiveSerializer.class));
    }

    public static ModelModule deserialize(CharIterator chars, PrimitiveSerializer primitives) {
        ModelModule module = new ModelModule();
        module.setUuid(primitives.deserializeString(chars));
        int numStrongNames = primitives.deserializeInt(chars);
        while (numStrongNames-- > 0) {
            module.strongNames.add((Object)primitives.deserializeString(chars));
        }
        module.setModuleName(primitives.deserializeString(chars));
        primitives = new ClusteringPrimitiveDeserializer(primitives, chars){

            @Override
            public <C> Class<C> deserializeClass(CharIterator c) {
                Class cls = super.deserializeClass(c);
                if (Model.class.isAssignableFrom(cls)) {
                    X_Model.getService().register((Class)Class.class.cast(cls));
                } else if (cls.isArray()) {
                    Class<?> component = cls.getComponentType();
                    while (component.isArray()) {
                        component = cls.getComponentType();
                    }
                    if (Model.class.isAssignableFrom(component)) {
                        X_Model.getService().register((Class)Class.class.cast(component));
                    }
                }
                return cls;
            }
        };
        int manifests = primitives.deserializeInt(chars);
        while (manifests-- > 0) {
            ModelManifest manifest = ModelManifest.deserialize(chars, primitives);
            module.manifests.put(manifest.getType(), (Object)manifest);
        }
        return module;
    }

    public int hashCode() {
        return this.getUuid().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModelModule) {
            ModelModule other = (ModelModule)obj;
            if (this.manifests.size() != other.manifests.size()) {
                return false;
            }
            if (!Objects.equals(this.moduleName, other.moduleName)) {
                return false;
            }
            if (!Objects.equals(this.getUuid(), other.getUuid())) {
                return false;
            }
            for (Map.Entry entry : this.manifests.entries()) {
                ModelManifest compare = (ModelManifest)other.manifests.get((String)entry.getKey());
                if (Objects.equals(compare, entry.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }
}

