/*
 * Decompiled with CFR 0.152.
 */
package xapi.model;

import javax.inject.Provider;
import xapi.annotation.gwt.MagicMethod;
import xapi.inject.X_Inject;
import xapi.model.api.Model;
import xapi.model.api.ModelKey;
import xapi.model.api.ModelManifest;
import xapi.model.service.ModelCache;
import xapi.model.service.ModelService;
import xapi.source.api.CharIterator;
import xapi.source.impl.StringCharIterator;
import xapi.util.api.SuccessHandler;

public class X_Model {
    private static final Provider<ModelCache> cache = X_Inject.singletonLazy(ModelCache.class);
    private static final Provider<ModelService> service = X_Inject.singletonLazy(ModelService.class);

    private X_Model() {
    }

    public static ModelCache cache() {
        return (ModelCache)cache.get();
    }

    @MagicMethod(doNotVisit=true, documentation="This magic method generates the model class and all of its dependent models, then re-routes to the same provider as X_Inject.instance()")
    public static <M extends Model> M create(Class<M> modelClass) {
        return ((ModelService)service.get()).create(modelClass);
    }

    @MagicMethod(doNotVisit=true, documentation="This magic method generates the model class and all of its dependent models")
    public static <M extends Model> String register(Class<M> modelClass) {
        return ((ModelService)service.get()).register(modelClass);
    }

    public static <M extends Model> void persist(M model, SuccessHandler<M> callback) {
        ((ModelService)service.get()).persist(model, callback);
    }

    public static <M extends Model> void load(Class<M> modelClass, ModelKey modelKey, SuccessHandler<M> callback) {
        ((ModelService)service.get()).load(modelClass, modelKey, callback);
    }

    public static <M extends Model> String serialize(Class<M> cls, M model) {
        return ((ModelService)service.get()).serialize(cls, model).toString();
    }

    public static <M extends Model> M deserialize(Class<M> cls, String model) {
        return ((ModelService)service.get()).deserialize(cls, (CharIterator)new StringCharIterator(model));
    }

    public static <M extends Model> String serialize(ModelManifest manifest, M model) {
        return ((ModelService)service.get()).serialize(manifest, model).toString();
    }

    public static <M extends Model> M deserialize(ModelManifest manifest, String model) {
        return ((ModelService)service.get()).deserialize(manifest, (CharIterator)new StringCharIterator(model));
    }

    public static ModelService getService() {
        return (ModelService)service.get();
    }

    public static String keyToString(ModelKey key) {
        return ((ModelService)service.get()).keyToString(key);
    }

    public static ModelKey keyFromString(String key) {
        return ((ModelService)service.get()).keyFromString(key);
    }

    public static ModelKey newKey(String kind) {
        return ((ModelService)service.get()).newKey("", kind);
    }

    public static ModelKey newKey(String namespace, String kind) {
        return ((ModelService)service.get()).newKey(namespace, kind);
    }

    public static ModelKey newKey(String namespace, String kind, String id) {
        return ((ModelService)service.get()).newKey(namespace, kind, id);
    }
}

