/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.model;

import xapi.annotation.model.ClientToServer;
import xapi.annotation.model.Key;
import xapi.annotation.model.Persistent;
import xapi.annotation.model.Serializable;
import xapi.annotation.model.ServerToClient;
import xapi.collect.X_Collect;
import xapi.collect.api.Fifo;
import xapi.collect.api.StringTo;
import xapi.collect.impl.StringToAbstract;
import xapi.dev.model.ModelField;
import xapi.model.api.Model;
import xapi.model.api.NestedModel;
import xapi.model.api.PersistentModel;
import xapi.source.api.HasQualifiedName;

public class HasModelFields
implements java.io.Serializable {
    private ClientToServer defaultToServer;
    private ServerToClient defaultToClient;
    StringTo<ModelField> fields = new StringToAbstract();
    private Persistent defaultPersistence;
    private Key key;

    public ModelField getOrMakeField(String field) {
        assert (field.length() > 0) : "Cannot have a field named \"\"";
        ModelField f = (ModelField)this.fields.get(field);
        if (f == null) {
            f = new ModelField(field);
            this.fields.put(field, (Object)f);
        }
        return f;
    }

    public Iterable<ModelField> getAllFields() {
        return this.fields.values();
    }

    public Iterable<ModelField> getAllSerializable() {
        Fifo fifo = X_Collect.newFifo();
        for (ModelField field : this.fields.values()) {
            Serializable serial = field.getSerializable();
            if (serial == null) {
                ClientToServer c2s = field.getClientToServer();
                if (c2s != null && c2s.enabled()) {
                    fifo.give((Object)field);
                    continue;
                }
                ServerToClient s2c = field.getServerToClient();
                if (s2c == null || !s2c.enabled()) continue;
                fifo.give((Object)field);
                continue;
            }
            fifo.give((Object)field);
        }
        return fifo.forEach();
    }

    public void setDefaultSerializable(Serializable defaultSerializable) {
        if (defaultSerializable == null) {
            this.defaultToClient = null;
            this.defaultToServer = null;
        } else {
            this.defaultToClient = defaultSerializable.serverToClient();
            this.defaultToServer = defaultSerializable.clientToServer();
        }
    }

    public ClientToServer getDefaultToServer() {
        return this.defaultToServer;
    }

    public ServerToClient getDefaultToClient() {
        return this.defaultToClient;
    }

    public void setDefaultPersistence(Persistent persist) {
        this.defaultPersistence = persist;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public static boolean isPersistentModel(HasQualifiedName type) {
        return type.getQualifiedName().equals(PersistentModel.class.getName());
    }

    public static boolean isNestedModel(HasQualifiedName type) {
        return type.getQualifiedName().equals(NestedModel.class.getName());
    }

    public static boolean isModel(HasQualifiedName type) {
        return type.getQualifiedName().equals(Model.class.getName()) || HasModelFields.isPersistentModel(type) || HasModelFields.isNestedModel(type);
    }
}

