/*
 * Decompiled with CFR 0.152.
 */
package xapi.test.model;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import xapi.model.impl.PrimitiveSerializerDefault;
import xapi.source.api.CharIterator;
import xapi.source.impl.StringCharIterator;

public class SerializationTest {
    int iterations;
    private PrimitiveSerializerDefault serializer;

    @Before
    public void before() {
        this.iterations = 65535;
        this.serializer = new PrimitiveSerializerDefault();
    }

    @Test
    public void testIntegerSerialization() {
        String serialized = this.serializer.serializeInt(Integer.MAX_VALUE);
        int deserialized = this.serializer.deserializeInt((CharIterator)new StringCharIterator(serialized));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)deserialized);
        serialized = this.serializer.serializeInt(0x7FFFFFFE);
        deserialized = this.serializer.deserializeInt((CharIterator)new StringCharIterator(serialized));
        Assert.assertEquals((long)0x7FFFFFFEL, (long)deserialized);
        serialized = this.serializer.serializeInt(-2147483647);
        deserialized = this.serializer.deserializeInt((CharIterator)new StringCharIterator(serialized));
        Assert.assertEquals((long)-2147483647L, (long)deserialized);
        serialized = this.serializer.serializeInt(Integer.MIN_VALUE);
        deserialized = this.serializer.deserializeInt((CharIterator)new StringCharIterator(serialized));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)deserialized);
        int i = this.iterations;
        while (i-- > -this.iterations) {
            serialized = this.serializer.serializeInt(i);
            deserialized = this.serializer.deserializeInt((CharIterator)new StringCharIterator(serialized));
            Assert.assertEquals((long)i, (long)deserialized);
        }
    }

    @Test
    public void testLongSerialization() {
        String serialized = this.serializer.serializeLong(Long.MAX_VALUE);
        long deserialized = this.serializer.deserializeLong((CharIterator)new StringCharIterator(serialized));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)deserialized);
        serialized = this.serializer.serializeLong(0x7FFFFFFFFFFFFFFEL);
        deserialized = this.serializer.deserializeLong((CharIterator)new StringCharIterator(serialized));
        Assert.assertEquals((long)0x7FFFFFFFFFFFFFFEL, (long)deserialized);
        serialized = this.serializer.serializeLong(Long.MIN_VALUE);
        deserialized = this.serializer.deserializeLong((CharIterator)new StringCharIterator(serialized));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)deserialized);
        serialized = this.serializer.serializeLong(-9223372036854775807L);
        deserialized = this.serializer.deserializeLong((CharIterator)new StringCharIterator(serialized));
        Assert.assertEquals((long)-9223372036854775807L, (long)deserialized);
        long i = this.iterations;
        while (i-- > (long)(-this.iterations)) {
            long value = i * (i - 1L) * (i + 7L);
            serialized = this.serializer.serializeLong(value);
            deserialized = this.serializer.deserializeLong((CharIterator)new StringCharIterator(serialized));
            Assert.assertEquals((long)value, (long)deserialized);
        }
    }

    @Test
    public void testDoubleSerialization() {
        String serialized = this.serializer.serializeDouble(Double.MAX_VALUE);
        double deserialized = this.serializer.deserializeDouble((CharIterator)new StringCharIterator(serialized));
        Assert.assertEquals((double)Double.MAX_VALUE, (double)deserialized, (double)0.0);
        serialized = this.serializer.serializeDouble(Double.MAX_VALUE);
        deserialized = this.serializer.deserializeDouble((CharIterator)new StringCharIterator(serialized));
        Assert.assertEquals((double)Double.MAX_VALUE, (double)deserialized, (double)0.0);
        serialized = this.serializer.serializeDouble(Double.MIN_VALUE);
        deserialized = this.serializer.deserializeDouble((CharIterator)new StringCharIterator(serialized));
        Assert.assertEquals((double)Double.MIN_VALUE, (double)deserialized, (double)0.0);
        serialized = this.serializer.serializeDouble(1.0);
        deserialized = this.serializer.deserializeDouble((CharIterator)new StringCharIterator(serialized));
        Assert.assertEquals((double)1.0, (double)deserialized, (double)0.0);
        serialized = this.serializer.serializeDouble(Double.POSITIVE_INFINITY);
        deserialized = this.serializer.deserializeDouble((CharIterator)new StringCharIterator(serialized));
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)deserialized, (double)0.0);
        serialized = this.serializer.serializeDouble(Double.NEGATIVE_INFINITY);
        deserialized = this.serializer.deserializeDouble((CharIterator)new StringCharIterator(serialized));
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)deserialized, (double)0.0);
        serialized = this.serializer.serializeDouble(Double.NaN);
        deserialized = this.serializer.deserializeDouble((CharIterator)new StringCharIterator(serialized));
        Assert.assertEquals((double)Double.NaN, (double)deserialized, (double)0.0);
        double i = this.iterations;
        while (true) {
            double d = i;
            i = d - 1.0;
            if (!(d > (double)(-this.iterations))) break;
            double value = i * i / 137.1 * i;
            serialized = this.serializer.serializeDouble(value);
            deserialized = this.serializer.deserializeDouble((CharIterator)new StringCharIterator(serialized));
            Assert.assertEquals((double)value, (double)deserialized, (double)0.0);
            value = 9.1 / value;
            serialized = this.serializer.serializeDouble(value);
            deserialized = this.serializer.deserializeDouble((CharIterator)new StringCharIterator(serialized));
            Assert.assertEquals((double)value, (double)deserialized, (double)0.0);
        }
    }

    @Test
    public void testBooleanArraySerialization() {
        int i = 100;
        while (i-- > 0) {
            boolean[] testArray = this.testBooleans(i, 0);
            String serialized = this.serializer.serializeBooleanArray(testArray);
            boolean[] deserialized = this.serializer.deserializeBooleanArray((CharIterator)new StringCharIterator(serialized));
            Assert.assertArrayEquals((String)("Array serialization failed for array of size " + i), (boolean[])testArray, (boolean[])deserialized);
            testArray = this.testBooleans(i, 1);
            serialized = this.serializer.serializeBooleanArray(testArray);
            deserialized = this.serializer.deserializeBooleanArray((CharIterator)new StringCharIterator(serialized));
            Assert.assertArrayEquals((String)("Array serialization failed for array of size " + i), (boolean[])testArray, (boolean[])deserialized);
        }
    }

    @Test
    public void testClassSerialization() {
        Class<Object> cls = Integer.TYPE;
        String serialized = this.serializer.serializeClass(cls);
        Class deserialized = this.serializer.deserializeClass((CharIterator)new StringCharIterator(serialized));
        Assert.assertEquals(cls, (Object)deserialized);
        cls = SerializationTest.class;
        serialized = this.serializer.serializeClass(cls);
        deserialized = this.serializer.deserializeClass((CharIterator)new StringCharIterator(serialized));
        Assert.assertEquals(cls, (Object)deserialized);
        cls = SerializationTest[].class;
        serialized = this.serializer.serializeClass(cls);
        deserialized = this.serializer.deserializeClass((CharIterator)new StringCharIterator(serialized));
        Assert.assertEquals(cls, (Object)deserialized);
        cls = long[].class;
        serialized = this.serializer.serializeClass(cls);
        deserialized = this.serializer.deserializeClass((CharIterator)new StringCharIterator(serialized));
        Assert.assertEquals(cls, (Object)deserialized);
    }

    private boolean[] testBooleans(int i, int order) {
        boolean[] test = new boolean[i];
        while (i-- > 0) {
            test[i] = i % 2 == order;
        }
        return test;
    }
}

