/*
 * Decompiled with CFR 0.152.
 */
package xapi.test.model;

import java.util.HashMap;
import xapi.annotation.inject.SingletonOverride;
import xapi.log.X_Log;
import xapi.model.api.Model;
import xapi.model.api.ModelKey;
import xapi.model.content.ModelComment;
import xapi.model.content.ModelContent;
import xapi.model.content.ModelRating;
import xapi.model.content.ModelText;
import xapi.model.impl.AbstractModelService;
import xapi.model.service.ModelService;
import xapi.model.user.ModelUser;
import xapi.test.model.content.ModelCommentTest;
import xapi.test.model.content.ModelContentTest;
import xapi.test.model.content.ModelRatingTest;
import xapi.test.model.content.ModelTextTest;
import xapi.test.model.content.ModelUserTest;
import xapi.util.api.SuccessHandler;

@SingletonOverride(priority=-2147483648, implFor=ModelService.class)
public class ModelServiceTestImpl
extends AbstractModelService {
    private final HashMap<ModelKey, Model> ramCache = new HashMap();

    protected <M extends Model> void doPersist(String type, M model, SuccessHandler<M> callback) {
        X_Log.info((Object[])new Object[]{((Object)((Object)this)).getClass(), "Persist", type, "as\n", model});
        ModelKey key = model.getKey();
        if (key == null) {
            key = this.newKey(null, type);
            model.setKey(key);
        }
        this.ramCache.put(key, model);
        callback.onSuccess(model);
    }

    public <M extends Model> void load(Class<M> modelClass, ModelKey modelKey, SuccessHandler<M> callback) {
        callback.onSuccess((Object)this.ramCache.get(modelKey));
    }

    public <T extends Model> T create(Class<T> key) {
        if (key == ModelText.class) {
            return (T)((Object)new ModelTextTest());
        }
        if (key == ModelContent.class) {
            return (T)((Object)new ModelContentTest());
        }
        if (key == ModelRating.class) {
            return (T)((Object)new ModelRatingTest());
        }
        if (key == ModelUser.class) {
            return (T)((Object)new ModelUserTest());
        }
        if (key == ModelComment.class) {
            return (T)((Object)new ModelCommentTest());
        }
        return (T)super.create(key);
    }
}

