/*
 * Decompiled with CFR 0.152.
 */
package xapi.test.model;

import org.junit.Assert;
import org.junit.Test;
import xapi.model.X_Model;
import xapi.model.api.Model;
import xapi.model.api.ModelKey;
import xapi.model.content.ModelContent;
import xapi.model.content.ModelText;

public class ModelSerializationTest {
    @Test
    public void testKeySerialization_Empty() {
        ModelKey key = X_Model.newKey((String)"testkind");
        String serialized = X_Model.keyToString((ModelKey)key);
        ModelKey asKey = X_Model.keyFromString((String)serialized);
        Assert.assertEquals((Object)key, (Object)asKey);
    }

    @Test
    public void testKeySerialization_Simple() {
        ModelKey key = X_Model.newKey((String)"ns", (String)"testkind");
        String serialized = X_Model.keyToString((ModelKey)key);
        ModelKey asKey = X_Model.keyFromString((String)serialized);
        Assert.assertEquals((Object)key, (Object)asKey);
        Assert.assertEquals((Object)"ns", (Object)key.getNamespace());
        Assert.assertEquals((Object)"testkind", (Object)key.getKind());
        Assert.assertEquals(null, (Object)key.getId());
    }

    @Test
    public void testKeySerialization_Full() {
        ModelKey key = X_Model.newKey((String)"ns", (String)"testkind", (String)"id");
        String serialized = X_Model.keyToString((ModelKey)key);
        ModelKey asKey = X_Model.keyFromString((String)serialized);
        Assert.assertEquals((Object)key, (Object)asKey);
        Assert.assertEquals((Object)"ns", (Object)key.getNamespace());
        Assert.assertEquals((Object)"testkind", (Object)key.getKind());
        Assert.assertEquals((Object)"id", (Object)key.getId());
    }

    @Test
    public void testKeySerialization_WithParent() {
        ModelKey key = X_Model.newKey((String)"ns", (String)"testkind", (String)"id");
        key = key.getChild("child", "123");
        String serialized = X_Model.keyToString((ModelKey)key);
        ModelKey asKey = X_Model.keyFromString((String)serialized);
        Assert.assertEquals((Object)key, (Object)asKey);
        Assert.assertEquals((Object)"ns", (Object)key.getNamespace());
        Assert.assertEquals((Object)"child", (Object)key.getKind());
        Assert.assertEquals((Object)"123", (Object)key.getId());
        Assert.assertEquals((Object)"ns", (Object)key.getParent().getNamespace());
        Assert.assertEquals((Object)"testkind", (Object)key.getParent().getKind());
        Assert.assertEquals((Object)"id", (Object)key.getParent().getId());
    }

    @Test
    public void testKeySerialization_WithMultipleParents() {
        ModelKey key = X_Model.newKey((String)"ns", (String)"testkind", (String)"id");
        key = key.getChild("child", "123");
        key = key.getChild("grandchild", "abc");
        String serialized = X_Model.keyToString((ModelKey)key);
        ModelKey asKey = X_Model.keyFromString((String)serialized);
        Assert.assertEquals((Object)key, (Object)asKey);
        Assert.assertEquals((Object)"ns", (Object)key.getNamespace());
        Assert.assertEquals((Object)"grandchild", (Object)key.getKind());
        Assert.assertEquals((Object)"abc", (Object)key.getId());
        key = key.getParent();
        Assert.assertEquals((Object)"ns", (Object)key.getNamespace());
        Assert.assertEquals((Object)"child", (Object)key.getKind());
        Assert.assertEquals((Object)"123", (Object)key.getId());
        key = key.getParent();
        Assert.assertEquals((Object)"ns", (Object)key.getNamespace());
        Assert.assertEquals((Object)"testkind", (Object)key.getKind());
        Assert.assertEquals((Object)"id", (Object)key.getId());
    }

    @Test
    public void testSimpleSerialization() {
        ModelText text = (ModelText)X_Model.create(ModelText.class);
        long time = System.currentTimeMillis();
        text.setText("Hello World");
        text.setTime((double)time);
        String serialized = X_Model.serialize(ModelText.class, (Model)text);
        ModelText asModel = (ModelText)X_Model.deserialize(ModelText.class, (String)serialized);
        Assert.assertEquals((Object)text, (Object)asModel);
    }

    @Test
    public void testSimpleSerialization_WithKey() {
        ModelText text = (ModelText)X_Model.create(ModelText.class);
        text.setKey(X_Model.newKey((String)"ns", (String)"text", (String)"id"));
        long time = System.currentTimeMillis();
        text.setText("Hello World");
        text.setTime((double)time);
        String serialized = X_Model.serialize(ModelText.class, (Model)text);
        ModelText asModel = (ModelText)X_Model.deserialize(ModelText.class, (String)serialized);
        Assert.assertEquals((Object)text, (Object)asModel);
        Assert.assertNotNull((String)"Deserialized model must have a key!", (Object)asModel.getKey());
        text.setText("different");
        Assert.assertEquals((Object)text, (Object)asModel);
    }

    @Test
    public void testComplexSerialization() {
        ModelContent content = (ModelContent)X_Model.create(ModelContent.class);
        long time = System.currentTimeMillis();
        content.setText("Hello World");
        content.setTime((double)time);
        content.setRelated(new ModelContent[]{(ModelContent)X_Model.create(ModelContent.class)});
        String serialized = X_Model.serialize(ModelContent.class, (Model)content);
        ModelContent asModel = (ModelContent)X_Model.deserialize(ModelContent.class, (String)serialized);
        Assert.assertEquals((Object)content, (Object)asModel);
    }
}

