/*
 * Decompiled with CFR 0.152.
 */
package xapi.test.model;

import org.junit.Assert;
import org.junit.Test;
import xapi.annotation.model.GetterFor;
import xapi.annotation.model.GetterForBuilder;
import xapi.annotation.model.SetterFor;
import xapi.annotation.model.SetterForBuilder;
import xapi.model.api.ModelManifest;
import xapi.model.content.ModelContent;
import xapi.model.impl.ModelUtil;

public class ModelManifestSerializationTest {
    @Test
    public void testSerializationRoundTrip() {
        ModelManifest manifest = ModelUtil.createManifest(ModelContent.class);
        String asString = ModelManifest.serialize((ModelManifest)manifest);
        ModelManifest asManifest = ModelManifest.deserialize((String)asString);
        System.out.println(asString);
        Assert.assertEquals((Object)manifest, (Object)asManifest);
    }

    @Test
    public void testEquality() throws Throwable {
        ModelManifest manifest1 = ModelUtil.createManifest(ModelContent.class);
        ModelManifest manifest2 = ModelUtil.createManifest(ModelContent.class);
        Assert.assertEquals((Object)manifest1, (Object)manifest2);
    }

    @Test
    public void testModelFieldEquality() throws Throwable {
        ModelManifest.MethodData method1 = new ModelManifest.MethodData("getName");
        ModelManifest.MethodData method2 = new ModelManifest.MethodData("getName");
        Assert.assertEquals((Object)method1, (Object)method2);
    }

    @Test
    public void testModelFieldInequality() throws Throwable {
        GetterFor getter = GetterForBuilder.buildGetterFor().setValue("name").build();
        SetterFor setter = SetterForBuilder.buildSetterFor().setValue("name").build();
        ModelManifest.MethodData method1 = new ModelManifest.MethodData("name", getter, null, null);
        ModelManifest.MethodData method2 = new ModelManifest.MethodData("name", null, setter, null);
        Assert.assertNotEquals((Object)method1, (Object)method2);
        Assert.assertEquals((Object)method1.getName(), (Object)method2.getName());
    }

    @Test
    @GetterFor(value="fake")
    public void testInequality() throws Throwable {
        ModelManifest manifest1 = ModelUtil.createManifest(ModelContent.class);
        ModelManifest manifest2 = ModelUtil.createManifest(ModelContent.class);
        GetterFor getter = this.getClass().getMethod("testInequality", new Class[0]).getAnnotation(GetterFor.class);
        Assert.assertNotNull((Object)getter);
        manifest2.addProperty("getFake", getter, null, null);
        Assert.assertNotEquals((Object)manifest1, (Object)manifest2);
    }
}

