/*
 * Decompiled with CFR 0.152.
 */
package xapi.model.impl;

import java.util.HashMap;
import java.util.Map;
import xapi.collect.X_Collect;
import xapi.collect.api.StringTo;
import xapi.log.X_Log;
import xapi.model.X_Model;
import xapi.model.api.Model;
import xapi.model.api.ModelKey;
import xapi.util.api.ErrorHandler;
import xapi.util.api.SuccessHandler;

public class AbstractModel
implements Model {
    protected StringTo<Object> map = X_Collect.newStringMap(Object.class);
    private Model parent;
    private ModelKey key;

    @Override
    public ModelKey getKey() {
        return this.key;
    }

    @Override
    public <T> T getProperty(String key) {
        return (T)this.map.get(key);
    }

    @Override
    public <T> T getProperty(String key, T dflt) {
        T o = this.getProperty(key);
        if (o == null) {
            return dflt;
        }
        return o;
    }

    @Override
    public Map<String, Object> getProperties() {
        Map<String, Object> props = this.emptyMap();
        for (String key : this.map.keys()) {
            props.put(key, this.map.get(key));
        }
        return props;
    }

    protected Map<String, Object> emptyMap() {
        return new HashMap<String, Object>();
    }

    @Override
    public Model setProperty(String key, Object value) {
        X_Log.info((Object[])new Object[]{this.map});
        try {
            this.map.put(key, value);
        }
        catch (Throwable e) {
            X_Log.error((Object[])new Object[]{e});
        }
        return this;
    }

    protected AbstractModel createNew() {
        return new AbstractModel();
    }

    @Override
    public Model removeProperty(String key) {
        this.map.remove(key);
        return this;
    }

    @Override
    public Model child(String propName) {
        Object existing = this.map.get(propName);
        assert (existing == null || existing instanceof Model) : "You requested a child model with property name " + propName + ", but an object of type " + existing.getClass() + " already existed in this location: " + existing;
        if (existing == null) {
            AbstractModel child = this.createNew();
            child.parent = this;
            existing = child;
            this.map.put(propName, existing);
        }
        return (Model)existing;
    }

    @Override
    public Model parent() {
        return this.parent;
    }

    @Override
    public Model cache(SuccessHandler<Model> callback) {
        X_Model.cache().cacheModel(this, callback);
        return this;
    }

    @Override
    public Model persist(SuccessHandler<Model> callback) {
        X_Model.persist(this, callback);
        return this;
    }

    @Override
    public Model delete(SuccessHandler<Model> callback) {
        X_Model.cache().deleteModel(this, callback);
        return this;
    }

    @Override
    public Model load(SuccessHandler<Model> callback, boolean useCache) {
        block2: {
            try {
                Model model = X_Model.cache().getModel(this.getKey().toString());
                callback.onSuccess((Object)model);
            }
            catch (Exception e) {
                if (!(callback instanceof ErrorHandler)) break block2;
                ((ErrorHandler)callback).onError((Throwable)e);
            }
        }
        return this;
    }

    @Override
    public Model flush() {
        return this;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

