/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.model;

import java.util.HashSet;
import java.util.Iterator;
import xapi.annotation.model.ClientToServer;
import xapi.annotation.model.Serializable;
import xapi.annotation.model.ServerToClient;
import xapi.collect.X_Collect;
import xapi.collect.api.Fifo;
import xapi.dev.model.HasModelFields;
import xapi.dev.model.ModelField;
import xapi.dev.source.ClassBuffer;
import xapi.dev.source.MethodBuffer;
import xapi.dev.source.SourceBuilder;
import xapi.source.X_Source;
import xapi.source.api.IsType;

public class ModelGenerator {
    private ClassBuffer cb;

    public ModelGenerator(SourceBuilder<?> builder) {
        this.cb = builder.getClassBuffer();
    }

    public void createFactory(String qualifiedSourceName) {
        this.cb.createMethod("static " + qualifiedSourceName + " newInstance()").println("return new " + this.cb.getSimpleName() + "();");
    }

    public MethodBuffer createMethod(String returnType, String methodName, String params) {
        return this.cb.createMethod("public " + returnType + " " + methodName + "( " + params + " )");
    }

    public void setSuperClass(String qualifiedSourceName) {
        this.cb.setSuperClass(qualifiedSourceName);
    }

    public String generateModel(IsType type, HasModelFields fields) {
        for (ModelField field : fields.getAllFields()) {
            if (field.getType() == null) {
                throw new RuntimeException();
            }
            HashSet publicGetters = new HashSet();
            for (ModelField.GetterMethod getter : field.getGetters()) {
                String datatype = getter.returnType.getQualifiedName();
                MethodBuffer mb = this.createMethod(datatype, getter.methodName, "");
                mb.println("return this.<" + (getter.returnType.isPrimitive() ? X_Source.primitiveToObject((String)datatype) : datatype) + ">getProperty(\"" + field.getName() + "\");");
            }
        }
        return "";
    }

    public ModelSerializerResult generateSerializers(IsType type, HasModelFields fields) {
        boolean toClientEnabled;
        Iterator<ModelField> serializable = fields.getAllSerializable().iterator();
        if (!serializable.hasNext()) {
            return null;
        }
        Fifo toServer = X_Collect.newFifo();
        Fifo toClient = X_Collect.newFifo();
        ServerToClient clientReceives = fields.getDefaultToClient();
        ClientToServer serverReceives = fields.getDefaultToServer();
        Serializable defaultSerializable = fields.getDefaultSerializable();
        boolean bl = defaultSerializable == null ? clientReceives != null && clientReceives.enabled() : (toClientEnabled = clientReceives == null || clientReceives.enabled());
        boolean toServerEnabled = defaultSerializable == null ? serverReceives != null && serverReceives.enabled() : serverReceives == null || serverReceives.enabled();
        boolean balanced = true;
        while (serializable.hasNext()) {
            ServerToClient server;
            ModelField field = serializable.next();
            boolean addedClient = false;
            if (toClientEnabled && ((server = field.getServerToClient()) == null || server.enabled())) {
                toClient.give((Object)field);
                addedClient = true;
            }
            if (!toServerEnabled) continue;
            ClientToServer client = field.getClientToServer();
            if (client == null || client.enabled()) {
                toServer.give((Object)field);
                continue;
            }
            if (!addedClient) continue;
            balanced = false;
        }
        ModelSerializerResult result = this.writeClientSerializer(balanced, toClient.forEach(), toServer.forEach());
        if (balanced) {
            return result;
        }
        return this.writeServerSerializer(result, toClient.forEach(), toServer.forEach());
    }

    protected ModelSerializerResult writeClientSerializer(boolean balanced, Iterable<ModelField> toClient, Iterable<ModelField> toServer) {
        ModelSerializerResult result = new ModelSerializerResult();
        return result;
    }

    protected ModelSerializerResult writeServerSerializer(ModelSerializerResult result, Iterable<ModelField> toClient, Iterable<ModelField> toServer) {
        return result;
    }

    public static final class ModelSerializerResult {
        public MethodBuffer clientDeserializer;
        public MethodBuffer clientSerializer;
        public MethodBuffer clientInstantiator;
        public MethodBuffer serverDeserializer;
        public MethodBuffer serverSerializer;
        public MethodBuffer serverInstantiator;
    }
}

