/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.model;

import xapi.annotation.model.ClientToServer;
import xapi.annotation.model.Key;
import xapi.annotation.model.Persistent;
import xapi.annotation.model.Serializable;
import xapi.annotation.model.ServerToClient;
import xapi.collect.X_Collect;
import xapi.collect.api.Fifo;
import xapi.source.api.IsType;

public class ModelField {
    private final String name;
    private String type;
    private ClientToServer clientToServer;
    private ServerToClient serverToClient;
    private Key key;
    private Persistent persistent;
    private Serializable serializable;
    private boolean listType;
    private boolean mapType;
    private boolean publicSetter;
    private boolean publicAdder;
    private boolean publicRemover;
    private boolean publicClear;
    private final Fifo<GetterMethod> getters;
    private final Fifo<SetterMethod> setters;
    private final Fifo<ActionMethod> actions;

    public ModelField(String name) {
        this.name = name;
        this.getters = X_Collect.newFifo();
        this.setters = X_Collect.newFifo();
        this.actions = X_Collect.newFifo();
    }

    public ClientToServer getClientToServer() {
        return this.clientToServer;
    }

    public ModelField setClientToServer(ClientToServer clientToServer) {
        this.clientToServer = clientToServer;
        return this;
    }

    public Key getKey() {
        return this.key;
    }

    public ModelField setKey(Key key) {
        this.key = key;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ServerToClient getServerToClient() {
        return this.serverToClient;
    }

    public ModelField setServerToClient(ServerToClient serverToClient) {
        this.serverToClient = serverToClient;
        return this;
    }

    public Serializable getSerializable() {
        return this.serializable;
    }

    public ModelField setSerializable(Serializable serializable) {
        this.serializable = serializable;
        return this;
    }

    public Persistent getPersistent() {
        return this.persistent;
    }

    public ModelField setPersistent(Persistent persistent) {
        this.persistent = persistent;
        return this;
    }

    public boolean equals(Object obj) {
        return obj == this ? true : (obj instanceof ModelField ? this.name.equals(((ModelField)obj).name) : false);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isPublicClear() {
        return this.publicClear;
    }

    public ModelField setPublicClear(boolean publicClear) {
        this.publicClear = publicClear;
        return this;
    }

    public boolean isPublicRemover() {
        return this.publicRemover;
    }

    public ModelField setPublicRemover(boolean publicRemover) {
        this.publicRemover = publicRemover;
        return this;
    }

    public boolean isPublicAdder() {
        return this.publicAdder;
    }

    public ModelField setPublicAdder(boolean publicAdder) {
        this.publicAdder = publicAdder;
        return this;
    }

    public boolean isPublicSetter() {
        return this.publicSetter;
    }

    public ModelField setPublicSetter(boolean publicSetter) {
        this.publicSetter = publicSetter;
        return this;
    }

    public boolean isMapType() {
        return this.mapType;
    }

    public ModelField setMapType(boolean mapType) {
        this.mapType = mapType;
        return this;
    }

    public boolean isListType() {
        return this.listType;
    }

    public ModelField setListType(boolean listType) {
        this.listType = listType;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public GetterMethod addGetter(IsType returns, String methodName) {
        GetterMethod mthd = new GetterMethod();
        mthd.returnType = returns;
        mthd.methodName = methodName;
        this.getters.give((Object)mthd);
        return mthd;
    }

    public SetterMethod addSetter(IsType returns, String methodName, IsType[] parameters) {
        SetterMethod mthd = new SetterMethod();
        mthd.returnType = returns;
        mthd.methodName = methodName;
        mthd.params = parameters;
        this.setters.give((Object)mthd);
        mthd.fluent = mthd.returnType.getQualifiedName().equals(this.type);
        return mthd;
    }

    public void addAction(IsType returns, String methodName, IsType[] parameters) {
        ActionMethod mthd = new ActionMethod();
        mthd.returnType = returns;
        mthd.methodName = methodName;
        mthd.params = parameters;
        this.actions.give((Object)mthd);
    }

    public Iterable<GetterMethod> getGetters() {
        return this.getters.forEach();
    }

    class ActionMethod {
        IsType returnType;
        String methodName;
        IsType[] params;

        ActionMethod() {
        }
    }

    class QueryMethod
    extends ModelMethod {
        IsType[] params;
        public boolean fluent;
        boolean fromArray;
        boolean fromCollection;
        boolean fromMap;
        boolean fromHasValues;
        boolean fromIterable;
        boolean firesEvents;

        QueryMethod() {
        }
    }

    class DeleterMethod
    extends ModelMethod {
        IsType[] params;
        public boolean fluent;
        boolean fromArray;
        boolean fromCollection;
        boolean fromMap;
        boolean fromHasValues;
        boolean fromIterable;
        boolean firesEvents;

        DeleterMethod() {
        }
    }

    class SetterMethod
    extends ModelMethod {
        IsType[] params;
        public boolean fluent;
        boolean fromArray;
        boolean fromCollection;
        boolean fromMap;
        boolean fromHasValues;
        boolean fromIterable;
        boolean firesEvents;

        SetterMethod() {
        }
    }

    class GetterMethod
    extends ModelMethod {
        boolean toArray;
        boolean toCollection;
        boolean toMap;
        boolean toHasValues;
        boolean toIterable;

        GetterMethod() {
        }
    }

    class ModelMethod {
        String fieldName;
        IsType returnType;
        String methodName;

        ModelMethod() {
        }
    }
}

