/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.model;

import xapi.annotation.model.ClientToServer;
import xapi.annotation.model.Serializable;
import xapi.annotation.model.ServerToClient;
import xapi.collect.X_Collect;
import xapi.collect.api.Fifo;
import xapi.collect.api.StringTo;
import xapi.dev.model.ModelField;

public class HasModelFields {
    private Serializable defaultSerializable;
    private ClientToServer defaultToServer;
    private ServerToClient defaultToClient;
    StringTo<ModelField> fields = X_Collect.newStringMap(ModelField.class);

    public ModelField getOrMakeField(String field) {
        assert (field.length() > 0) : "Cannot have a field named \"\"";
        ModelField f = (ModelField)this.fields.get(field);
        if (f == null) {
            f = new ModelField(field);
            this.fields.put(field, (Object)f);
        }
        return f;
    }

    public Iterable<ModelField> getAllFields() {
        return this.fields.values();
    }

    public Iterable<ModelField> getAllPublicSetters() {
        Fifo fifo = X_Collect.newFifo();
        for (ModelField field : this.fields.values()) {
            if (!field.isPublicSetter()) continue;
            fifo.give((Object)field);
        }
        return fifo.forEach();
    }

    public Iterable<ModelField> getAllPublicAdders() {
        Fifo fifo = X_Collect.newFifo();
        for (ModelField field : this.fields.values()) {
            if (!field.isPublicAdder()) continue;
            fifo.give((Object)field);
        }
        return fifo.forEach();
    }

    public Iterable<ModelField> getAllPublicRemovers() {
        Fifo fifo = X_Collect.newFifo();
        for (ModelField field : this.fields.values()) {
            if (!field.isPublicRemover()) continue;
            fifo.give((Object)field);
        }
        return fifo.forEach();
    }

    public Iterable<ModelField> getAllPublicClears() {
        Fifo fifo = X_Collect.newFifo();
        for (ModelField field : this.fields.values()) {
            if (!field.isPublicClear()) continue;
            fifo.give((Object)field);
        }
        return fifo.forEach();
    }

    public Iterable<ModelField> getAllSerializable() {
        Fifo fifo = X_Collect.newFifo();
        for (ModelField field : this.fields.values()) {
            Serializable serial = field.getSerializable();
            if (serial == null) {
                ClientToServer c2s = field.getClientToServer();
                if (c2s != null && c2s.enabled()) {
                    fifo.give((Object)field);
                    continue;
                }
                ServerToClient s2c = field.getServerToClient();
                if (s2c == null || !s2c.enabled()) continue;
                fifo.give((Object)field);
                continue;
            }
            fifo.give((Object)field);
        }
        return fifo.forEach();
    }

    public Serializable getDefaultSerializable() {
        return this.defaultSerializable;
    }

    public void setDefaultSerializable(Serializable defaultSerializable) {
        this.defaultSerializable = defaultSerializable;
    }

    public ClientToServer getDefaultToServer() {
        return this.defaultToServer;
    }

    public void setDefaultToServer(ClientToServer defaultToServer) {
        this.defaultToServer = defaultToServer;
    }

    public ServerToClient getDefaultToClient() {
        return this.defaultToClient;
    }

    public void setDefaultToClient(ServerToClient defaultToClient) {
        this.defaultToClient = defaultToClient;
    }
}

