/*
 * Decompiled with CFR 0.152.
 */
package xapi.jre.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import xapi.annotation.inject.InstanceDefault;
import xapi.annotation.inject.SingletonDefault;
import xapi.collect.api.StringDictionary;
import xapi.io.X_IO;
import xapi.io.api.IOCallback;
import xapi.io.api.IOMessage;
import xapi.io.api.IORequest;
import xapi.io.api.LineReader;
import xapi.io.api.StringReader;
import xapi.io.impl.AbstractIOService;
import xapi.io.service.IOService;
import xapi.log.X_Log;
import xapi.log.api.LogLevel;
import xapi.time.X_Time;
import xapi.time.api.Moment;
import xapi.util.X_Runtime;
import xapi.util.api.ReceivesValue;
import xapi.util.impl.RunUnsafe;

@InstanceDefault(implFor=IOService.class)
@SingletonDefault(implFor=IOService.class)
public class IOServiceDefault
extends AbstractIOService<URLConnection> {
    @Override
    public IORequest<String> get(String uri, final StringDictionary<String> headers, IOCallback<IOMessage<String>> callback) {
        String url = this.normalize(uri);
        if (callback.isCancelled()) {
            return cancelled;
        }
        Moment startUp = X_Time.now();
        try {
            URL asUrl = new URL(url);
            final URLConnection connect = asUrl.openConnection();
            connect.setDoInput(true);
            connect.setDoOutput(false);
            if (headers != null) {
                headers.forKeys((ReceivesValue)new ReceivesValue<String>(){

                    public void set(String key) {
                        String value = (String)headers.getValue((Object)key);
                        connect.setRequestProperty(key, value);
                    }
                });
            }
            this.applySettings(connect, 0);
            LogLevel logLevel = this.logLevel();
            if (X_Log.loggable((LogLevel)logLevel)) {
                X_Log.log(this.getClass(), (LogLevel)logLevel, (Object[])new Object[]{"Startup time for ", url, "took", X_Time.difference((Moment)startUp)});
            }
            IORequestDefault request = this.createRequest();
            this.sendRequest(connect, request, callback, url, headers, null);
            return request;
        }
        catch (Throwable e) {
            callback.onError(e);
            if (X_Runtime.isDebug()) {
                X_Log.warn((Object[])new Object[]{"IO Error", e});
            }
            return cancelled;
        }
    }

    @Override
    public IORequest<String> post(String uri, String body, final StringDictionary<String> headers, IOCallback<IOMessage<String>> callback) {
        String url = this.normalize(uri);
        if (callback.isCancelled()) {
            return cancelled;
        }
        Moment startUp = X_Time.now();
        try {
            URL asUrl = new URL(url);
            final URLConnection connect = asUrl.openConnection();
            connect.setDoInput(true);
            connect.setDoOutput(true);
            if (headers != null) {
                headers.forKeys((ReceivesValue)new ReceivesValue<String>(){

                    public void set(String key) {
                        String value = (String)headers.getValue((Object)key);
                        connect.setRequestProperty(key, value);
                    }
                });
            }
            this.applySettings(connect, 2);
            LogLevel logLevel = this.logLevel();
            if (X_Log.loggable((LogLevel)logLevel)) {
                X_Log.log(this.getClass(), (LogLevel)logLevel, (Object[])new Object[]{"Startup time for ", url, "took", X_Time.difference((Moment)startUp)});
            }
            IORequestDefault request = this.createRequest();
            this.sendRequest(connect, request, callback, url, headers, body);
            return request;
        }
        catch (Throwable e) {
            callback.onError(e);
            if (X_Runtime.isDebug()) {
                X_Log.warn((Object[])new Object[]{"IO Error", e});
            }
            return cancelled;
        }
    }

    protected void sendRequest(final URLConnection connect, final IORequestDefault request, final IOCallback<IOMessage<String>> callback, final String url, final StringDictionary<String> headers, final String body) {
        final LogLevel logLevel = this.logLevel();
        final Moment before = X_Time.now();
        X_Time.runUnsafe((RunUnsafe)new RunUnsafe(){

            /*
             * Exception decompiling
             */
            protected void doRun() throws Throwable {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    private InputStream toStream(String body, StringDictionary<String> headers) {
        return X_IO.toStreamUtf8(body);
    }

    protected IORequestDefault createRequest() {
        return new IORequestDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String drainInput(InputStream in, IOCallback<IOMessage<String>> callback) throws IOException {
        try {
            String line;
            BufferedReader read = new BufferedReader(new InputStreamReader(in));
            StringReader messageReader = new StringReader();
            if (callback instanceof LineReader) {
                messageReader.forwardTo((LineReader)((Object)callback));
            }
            messageReader.onStart();
            while ((line = read.readLine()) != null) {
                messageReader.onLine(line);
            }
            String message = messageReader.toString();
            messageReader.onEnd();
            String string = message;
            return string;
        }
        finally {
            in.close();
        }
    }

    static /* synthetic */ InputStream access$000(IOServiceDefault x0, String x1, StringDictionary x2) {
        return x0.toStream(x1, (StringDictionary<String>)x2);
    }

    public class IORequestDefault
    extends AbstractIOService.AbstractIORequest {
        private Thread connectionThread;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            super.cancel();
            if (this.connectionThread != null) {
                this.connectionThread.interrupt();
                this.connectionThread = null;
                IORequestDefault iORequestDefault = this;
                synchronized (iORequestDefault) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String response() {
            Object object;
            if (!super.isStarted()) {
                object = this;
                synchronized (object) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        this.cancel();
                        Thread.currentThread().interrupt();
                    }
                }
            }
            if (this.connectionThread != null) {
                object = this.connectionThread;
                synchronized (object) {
                    try {
                        if (this.connectionThread != null) {
                            this.connectionThread.join();
                        }
                    }
                    catch (InterruptedException ignored) {
                        this.cancel();
                        Thread.currentThread().interrupt();
                    }
                    this.connectionThread = null;
                }
            }
            return this.getValue();
        }

        public void setConnectionThread(Thread thread) {
            this.connectionThread = thread;
        }

        static /* synthetic */ Thread access$102(IORequestDefault x0, Thread x1) {
            x0.connectionThread = x1;
            return x0.connectionThread;
        }
    }
}

