/*
 * Decompiled with CFR 0.152.
 */
package xapi.io.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class StringBufferOutputStream
extends OutputStream {
    private String charset;
    private final ByteArrayOutputStream bout = new ByteArrayOutputStream();

    public StringBufferOutputStream() {
        this("UTF-8");
    }

    public StringBufferOutputStream(String charset) {
        this.charset = charset;
    }

    @Override
    public void write(int b) throws IOException {
        this.bout.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.bout.write(b, off, len);
    }

    public String getContent() {
        return this.toString();
    }

    public String toString() {
        try {
            return new String(this.bout.toByteArray(), this.charset);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return new String(this.bout.toByteArray());
        }
    }

    @Override
    public void close() throws IOException {
        this.bout.close();
    }
}

