/*
 * Decompiled with CFR 0.152.
 */
package xapi.io.impl;

import xapi.collect.X_Collect;
import xapi.collect.api.StringDictionary;
import xapi.collect.api.StringTo;
import xapi.except.NotYetImplemented;
import xapi.io.X_IO;
import xapi.io.api.IOCallback;
import xapi.io.api.IOMessage;
import xapi.io.api.IORequest;
import xapi.io.api.IORequestBuilder;
import xapi.io.service.IOService;
import xapi.log.X_Log;
import xapi.util.X_Runtime;
import xapi.util.X_String;
import xapi.util.api.ConvertsValue;
import xapi.util.api.ErrorHandler;
import xapi.util.api.Pointer;
import xapi.util.api.SuccessHandler;

public class IORequestBuilderDefault<Out>
implements IORequestBuilder<Out> {
    private int modifier;
    private String url;
    private ConvertsValue<String, Out> deserializer;
    private ConvertsValue<Out, String> serializer;
    private final StringDictionary<String> headers = this.initHeaders();
    private Out value;

    @Override
    public IORequest<Out> send(SuccessHandler<Out> handler) {
        IORequest<String> io;
        int modifer = this.modifier;
        String url = this.url;
        ConvertsValue<Out, String> serializer = this.serializer;
        StringDictionary<String> headerCopy = this.initHeaders();
        X_Collect.copyDictionary(this.headers, headerCopy);
        Pointer result = new Pointer(this.value);
        Pointer failure = new Pointer(null);
        IOService service = this.service();
        IO<Out> request = this.createIO(result, (Pointer<Throwable>)failure);
        IOCallback<IOMessage<String>> callback = this.createCallback(request, result, (Pointer<Throwable>)failure, this.deserializer, handler);
        switch (modifer) {
            case 4: {
                throw new NotYetImplemented("Method DELETE not yet implemented");
            }
            case 0: {
                io = service.get(url, headerCopy, callback);
                break;
            }
            case 2: {
                throw new NotYetImplemented("Method POST not yet implemented");
            }
            case 3: {
                throw new NotYetImplemented("Method PUT not yet implemented");
            }
            case 1: {
                throw new NotYetImplemented("Method HEAD not yet implemented");
            }
            case 5: {
                throw new NotYetImplemented("Method PATCH not yet implemented");
            }
            default: {
                throw new UnsupportedOperationException("Unknown request type " + modifer);
            }
        }
        request.setRequest(io);
        return request;
    }

    private IOCallback<IOMessage<String>> createCallback(final IO<Out> request, final Pointer<Out> result, final Pointer<Throwable> failure, final ConvertsValue<String, Out> deserializer, final SuccessHandler<Out> handler) {
        return new IOCallback<IOMessage<String>>(){
            private boolean cancel = false;

            public void onSuccess(IOMessage<String> t) {
                if (this.cancel) {
                    if (X_Runtime.isDebug()) {
                        X_Log.trace((Object[])new Object[]{"Ignoring cancelled message", t.url(), t.body()});
                    }
                    return;
                }
                request.pending = false;
                request.statusCode = t.statusCode();
                request.statusText = t.statusMessage();
                if (deserializer == null) {
                    assert (X_String.isEmpty((String)t.body())) : "Non-null response without a deserializer instance for " + IORequestBuilderDefault.access$200(IORequestBuilderDefault.this) + "\n Response: " + t.body();
                } else {
                    result.set(deserializer.convert((Object)t.body()));
                }
                if (handler != null) {
                    handler.onSuccess(result.get());
                }
            }

            @Override
            public void onError(Throwable e) {
                failure.set((Object)e);
                request.pending = false;
                if (handler instanceof ErrorHandler) {
                    ((ErrorHandler)handler).onError(e);
                }
            }

            @Override
            public void onCancel() {
                this.cancel = true;
                request.cancel();
            }

            @Override
            public boolean isCancelled() {
                return this.cancel;
            }
        };
    }

    protected IO<Out> createIO(Pointer<Out> result, Pointer<Throwable> failure) {
        return new IO<Out>(result, failure);
    }

    protected byte[] toBinary(String convert) {
        return X_String.getBytes((String)convert);
    }

    protected StringDictionary<String> initHeaders() {
        return X_Collect.newDictionary();
    }

    @Override
    public IOService service() {
        return X_IO.getIOService();
    }

    @Override
    public IORequestBuilder<Out> setDeserializer(ConvertsValue<String, Out> deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    @Override
    public IORequestBuilder<Out> setSerializer(ConvertsValue<Out, String> serializer) {
        this.serializer = serializer;
        return this;
    }

    @Override
    public IORequestBuilder<Out> setUrl(String url) {
        this.url = url;
        return this;
    }

    @Override
    public IORequestBuilder<Out> setHeader(String header, String value) {
        this.headers.setValue((Object)header, (Object)value);
        return this;
    }

    @Override
    public IORequestBuilder<Out> setModifier(int modifier) {
        this.modifier = modifier;
        return this;
    }

    @Override
    public IORequestBuilder<Out> setValue(Out value) {
        this.value = value;
        return this;
    }

    static /* synthetic */ String access$200(IORequestBuilderDefault x0) {
        return x0.url;
    }

    protected static class IO<Out>
    implements IORequest<Out> {
        boolean pending = true;
        boolean cancel = false;
        private IORequest<String> request;
        private final Pointer<Out> response;
        private final Pointer<Throwable> error;
        private String statusText;
        private int statusCode;

        public IO(Pointer<Out> response, Pointer<Throwable> error) {
            this.response = response;
            this.error = error;
        }

        @Override
        public boolean isPending() {
            return this.pending;
        }

        @Override
        public boolean isSuccess() {
            if (this.request == null) {
                return false;
            }
            return !this.pending && !this.cancel && this.error.get() == null && this.request.isSuccess();
        }

        @Override
        public void cancel() {
            this.cancel = true;
            this.pending = false;
            this.request.cancel();
        }

        @Override
        public Out response() {
            try {
                Object object = this.response.get();
                return (Out)object;
            }
            finally {
                this.pending = false;
            }
        }

        @Override
        public StringTo.Many<String> headers() {
            return this.request.headers();
        }

        public void setRequest(IORequest<String> request) {
            this.request = request;
            if (this.cancel) {
                request.cancel();
            }
        }

        @Override
        public int getStatusCode() {
            return this.statusCode;
        }

        @Override
        public String getStatusText() {
            return this.statusText;
        }
    }
}

