/*
 * Decompiled with CFR 0.152.
 */
package xapi.io.impl;

import javax.inject.Provider;
import xapi.collect.X_Collect;
import xapi.collect.api.ClassTo;
import xapi.collect.api.StringDictionary;
import xapi.collect.api.StringTo;
import xapi.io.api.IOCallback;
import xapi.io.api.IOMessage;
import xapi.io.api.IORequest;
import xapi.io.api.IORequestBuilder;
import xapi.io.impl.IORequestBuilderDefault;
import xapi.io.service.IOService;
import xapi.log.api.LogLevel;
import xapi.util.X_Properties;
import xapi.util.api.ConvertsValue;
import xapi.util.api.ReceivesValue;
import xapi.util.api.RemovalHandler;

public abstract class AbstractIOService<Transport>
implements IOService {
    protected static final IORequest<String> cancelled = new IORequest<String>(){

        @Override
        public boolean isPending() {
            return false;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public void cancel() {
        }

        @Override
        public String response() {
            return null;
        }

        @Override
        public StringTo.Many<String> headers() {
            return X_Collect.newStringMultiMap(String.class);
        }

        @Override
        public int getStatusCode() {
            return -3;
        }

        @Override
        public String getStatusText() {
            return "Request Cancelled";
        }
    };
    private static final Class<ConvertsValue<?, String>> SERIAL_CLASS = (Class)Class.class.cast(ConvertsValue.class);
    private static final Class<ConvertsValue<String, ?>> DESERIAL_CLASS = (Class)Class.class.cast(ConvertsValue.class);
    protected final ClassTo<ConvertsValue<?, String>> serializers = X_Collect.newClassMap(SERIAL_CLASS);
    protected final ClassTo<ConvertsValue<String, ?>> deserializers = X_Collect.newClassMap(DESERIAL_CLASS);

    @Override
    public <V> IORequestBuilder<V> request(Class<V> classLit, String id) {
        return this.createRequestBuilder().setUrl(this.toUrl(classLit, id)).setDeserializer((ConvertsValue)ConvertsValue.class.cast(this.deserializers.get(classLit))).setSerializer((ConvertsValue)ConvertsValue.class.cast(this.serializers.get(classLit)));
    }

    protected <V> IORequestBuilderDefault<V> createRequestBuilder() {
        return new IORequestBuilderDefault();
    }

    protected LogLevel logLevel() {
        return LogLevel.DEBUG;
    }

    @Override
    public <V> RemovalHandler registerParser(final Class<V> classLit, final ConvertsValue<V, String> serializer, final ConvertsValue<String, V> deserializer) {
        final ConvertsValue currentSerializer = (ConvertsValue)this.serializers.put(classLit, serializer);
        final ConvertsValue currentDeserialize = (ConvertsValue)this.deserializers.put(classLit, deserializer);
        if (serializer instanceof ReceivesValue) {
            ((ReceivesValue)serializer).set((Object)currentSerializer);
        }
        if (deserializer instanceof ReceivesValue) {
            ((ReceivesValue)deserializer).set((Object)currentDeserialize);
        }
        return new RemovalHandler(){

            public void remove() {
                if (AbstractIOService.this.serializers.get((Object)classLit) == serializer) {
                    AbstractIOService.this.serializers.put((Object)classLit, (Object)currentSerializer);
                }
                if (AbstractIOService.this.deserializers.get((Object)classLit) == deserializer) {
                    AbstractIOService.this.deserializers.put((Object)classLit, (Object)currentDeserialize);
                }
            }
        };
    }

    @Override
    public void put(String url, byte[] body, StringDictionary<String> headers, IOCallback<IOMessage<String>> callback) {
    }

    protected String uriBase() {
        String port = X_Properties.getProperty((String)"xapi.server.port", (String)"");
        return System.getProperty("xapi.server.host", "0.0.0.0") + (port.length() == 0 ? "" : ":" + port);
    }

    protected void applySettings(Transport connect, int modifiers) {
    }

    protected String normalize(String uri) {
        if (uri.charAt(0) == '/') {
            uri = this.uriBase() + uri;
        }
        if (!uri.contains("://")) {
            uri = "http://" + uri;
        }
        return uri;
    }

    protected String toUrl(Class<?> classLit, String id) {
        return id;
    }

    @Override
    public void delete(String url, StringDictionary<String> headers, IOCallback<IOMessage<String>> callback) {
    }

    public abstract class AbstractIORequest
    implements IORequest<String> {
        private boolean pending = true;
        private String value;
        private volatile boolean cancel;
        private boolean started;
        protected Provider<StringTo.Many<String>> resultHeaders;
        private int statusCode = -2;
        private String statusText = "Request Incomplete";

        @Override
        public boolean isPending() {
            return this.pending;
        }

        public void start() {
            this.started = true;
        }

        @Override
        public boolean isSuccess() {
            return !this.pending && !this.cancel && this.value != null;
        }

        @Override
        public void cancel() {
            this.pending = false;
            this.cancel = false;
        }

        @Override
        public StringTo.Many<String> headers() {
            return this.resultHeaders == null ? X_Collect.newStringMultiMap(String.class) : (StringTo.Many)this.resultHeaders.get();
        }

        public boolean isStarted() {
            return this.started;
        }

        public boolean isCancelled() {
            return this.cancel;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.pending = false;
            this.value = value;
        }

        public void setResultHeaders(Provider<StringTo.Many<String>> resultHeaders) {
            this.resultHeaders = resultHeaders;
        }

        public void setStatus(int statusCode, String statusText) {
            this.statusCode = statusCode;
            this.statusText = statusText;
        }

        @Override
        public int getStatusCode() {
            return this.statusCode;
        }

        @Override
        public String getStatusText() {
            return this.statusText;
        }
    }
}

