/*
 * Decompiled with CFR 0.152.
 */
package xapi.io.api;

import xapi.io.api.IOCallback;
import xapi.util.api.ErrorHandler;
import xapi.util.api.SuccessHandler;

public class DelegatingIOCallback<V>
implements IOCallback<V> {
    private SuccessHandler<V> success;
    private ErrorHandler<Throwable> failure;
    private boolean cancel;

    public DelegatingIOCallback(SuccessHandler<V> success) {
        this.success = success;
    }

    public DelegatingIOCallback(SuccessHandler<V> success, ErrorHandler<Throwable> failure) {
        this.success = success;
        this.failure = failure;
    }

    @Override
    public void onCancel() {
        this.success = null;
        this.failure = null;
        this.cancel = true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    @Override
    public void onError(Throwable e) {
        if (this.failure != null) {
            this.failure.onError(e);
        }
    }

    public void onSuccess(V t) {
        if (this.success != null) {
            this.success.onSuccess(t);
        }
    }
}

