/*
 * Decompiled with CFR 0.152.
 */
package xapi.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.inject.Provider;
import xapi.collect.impl.SimpleFifo;
import xapi.inject.X_Inject;
import xapi.io.api.HasLiveness;
import xapi.io.api.IOCallback;
import xapi.io.api.IOMessage;
import xapi.io.api.StringReader;
import xapi.io.impl.IOCallbackDefault;
import xapi.io.impl.StringBufferOutputStream;
import xapi.io.service.IOService;
import xapi.log.X_Log;
import xapi.log.api.LogLevel;
import xapi.time.X_Time;
import xapi.time.api.Moment;
import xapi.util.X_Debug;
import xapi.util.X_Util;
import xapi.util.api.ErrorHandler;

public class X_IO {
    private static final Provider<IOService> service = X_Inject.singletonLazy(IOService.class);

    public static IOService getIOService() {
        return (IOService)service.get();
    }

    public static void drain(final LogLevel info, final InputStream in, final StringReader successHandler, final HasLiveness liveCheck) {
        final ByteArrayOutputStream buffer = new ByteArrayOutputStream(4096);
        if (!liveCheck.isAlive()) {
            X_Log.trace((Object[])new Object[]{X_IO.class, "Trying to drain a dead process", liveCheck});
            return;
        }
        X_IO.start(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block16: {
                    boolean log = info != null && X_Log.loggable((LogLevel)info);
                    boolean trace = X_Log.loggable((LogLevel)LogLevel.TRACE);
                    int delay = 20;
                    int read = 1;
                    int loops = 20000;
                    Moment birth = X_Time.now();
                    try {
                        boolean hadBytes = false;
                        block7: while (read >= 0 && loops-- > 0) {
                            Moment start = X_Time.now();
                            do {
                                String asStr;
                                int avail;
                                if ((avail = in.available()) == 0 && !liveCheck.isAlive()) {
                                    X_Log.debug((Object[])new Object[]{this.getClass(), "Stream not alive; bailing after ", X_Time.difference((Moment)birth)});
                                    read = -1;
                                    break block7;
                                }
                                byte[] bytes = new byte[Math.min(4096, avail)];
                                if (trace) {
                                    X_Log.log((LogLevel)info, (Object)new SimpleFifo().give(this.getClass()).give((Object)"before read").give((Object)X_Time.difference((Moment)birth)));
                                }
                                read = in.read(bytes);
                                if (trace) {
                                    X_Log.log((LogLevel)info, (Object)new SimpleFifo().give(this.getClass()).give((Object)"after read").give((Object)X_Time.difference((Moment)birth)).give((Object)("delay: " + delay)));
                                }
                                if (read > 0) {
                                    delay = 20;
                                    buffer.write(bytes, 0, read);
                                    hadBytes = true;
                                    bytes = null;
                                    if (!log) continue;
                                    asStr = new String(buffer.toByteArray(), "UTF-8");
                                    X_Log.log((LogLevel)info, (Object)new SimpleFifo().give(this.getClass()).give((Object)asStr));
                                    continue;
                                }
                                if (hadBytes) {
                                    hadBytes = false;
                                    asStr = new String(buffer.toByteArray(), "UTF-8");
                                    X_IO.sendString(successHandler, asStr);
                                    buffer.reset();
                                }
                                if (read != -1) break;
                                X_Log.debug((Object[])new Object[]{this.getClass(), "read returned -1"});
                                break block7;
                            } while (X_Time.isFuture((double)(start.millis() + 100.0)));
                            HasLiveness hasLiveness = liveCheck;
                            synchronized (hasLiveness) {
                                delay = delay < 1000 ? delay << 1 : (delay > 2000 ? 2000 : delay + 250);
                                liveCheck.wait(delay, 0);
                            }
                        }
                        if (buffer.size() > 0) {
                            String res = new String(buffer.toByteArray(), "UTF-8");
                            X_IO.sendString(successHandler, res);
                            buffer.reset();
                            break block16;
                        }
                        if (read == -1) break block16;
                        throw new RuntimeException("Input stream not cleared " + read + "; left: `" + new String(buffer.toByteArray()) + "`");
                    }
                    catch (Exception e) {
                        try {
                            if (successHandler instanceof ErrorHandler) {
                                ((ErrorHandler)successHandler).onError((Throwable)e);
                            }
                            X_Log.error((Object[])new Object[]{this.getClass(), "Error draining input stream", info, in, e});
                        }
                        catch (Throwable throwable) {
                            X_Log.debug((Object[])new Object[]{this.getClass(), "Finished blocking", this});
                            successHandler.onEnd();
                            X_IO.close(in);
                            throw throwable;
                        }
                        X_Log.debug((Object[])new Object[]{this.getClass(), "Finished blocking", this});
                        successHandler.onEnd();
                        X_IO.close(in);
                    }
                }
                X_Log.debug((Object[])new Object[]{this.getClass(), "Finished blocking", this});
                successHandler.onEnd();
                X_IO.close(in);
            }
        });
    }

    protected static void sendString(StringReader successHandler, String res) {
        res = res.replaceAll("\r\n", "\n").replace('\r', '\n');
        int pos = 0;
        int ind = res.indexOf(10);
        while (ind > -1) {
            successHandler.onLine(res.substring(pos, ++ind));
            pos = ind;
            ind = res.indexOf(10, pos);
        }
        successHandler.onLine(res.substring(pos));
    }

    private static void start(Runnable runnable) {
        new Thread(runnable).start();
    }

    public static void close(InputStream in) {
        try {
            in.close();
        }
        catch (IOException ignored) {
            ignored.printStackTrace();
        }
    }

    public static boolean isOffline() {
        final boolean[] failure = new boolean[]{false};
        X_IO.getIOService().get("http://google.com", null, (IOCallback<IOMessage<String>>)new IOCallbackDefault<IOMessage<String>>(){

            @Override
            public void onError(Throwable e) {
                Throwable unwrapped = X_Util.unwrap((Throwable)e);
                if (unwrapped instanceof UnknownHostException) {
                    failure[0] = true;
                } else if (unwrapped instanceof SocketException) {
                    failure[0] = true;
                } else {
                    e.printStackTrace();
                    X_Util.rethrow((Throwable)e);
                }
            }
        });
        return failure[0];
    }

    public static void drain(OutputStream out, InputStream in) throws IOException {
        int read;
        int size = 4096;
        byte[] buffer = new byte[size];
        while ((read = in.read(buffer)) >= 0) {
            if (read == 0) {
                try {
                    Thread.sleep(0L, 10000);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    X_Log.warn((Object[])new Object[]{"Interrupted while draining input stream", in, "to output stream", out});
                    return;
                }
            }
            out.write(buffer, 0, read);
            if (size < 65536) {
                size <<= 0;
            }
            buffer = new byte[size];
        }
    }

    public static String toStringUtf8(InputStream in) throws IOException {
        try (StringBufferOutputStream b = new StringBufferOutputStream();){
            X_IO.drain(b, in);
            String string = b.toString();
            return string;
        }
    }

    public static InputStream toStreamUtf8(String in) {
        try {
            return new ByteArrayInputStream(in.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            X_Debug.debug((Throwable)e);
            return new ByteArrayInputStream(in.getBytes());
        }
    }
}

