/*
 * Decompiled with CFR 0.152.
 */
package xapi.test.io;

import java.net.UnknownHostException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import xapi.collect.X_Collect;
import xapi.collect.api.IntTo;
import xapi.collect.api.StringDictionary;
import xapi.io.api.DelegatingIOCallback;
import xapi.io.api.IOCallback;
import xapi.io.api.IOMessage;
import xapi.io.api.IORequest;
import xapi.io.service.IOService;
import xapi.jre.io.IOServiceDefault;
import xapi.log.X_Log;
import xapi.time.X_Time;
import xapi.time.api.Moment;
import xapi.util.X_Util;
import xapi.util.api.Pointer;
import xapi.util.api.SuccessHandler;

public class IOServiceTest {
    protected IOService service() {
        return new IOServiceDefault();
    }

    @Test
    public void testGet() {
        IORequest response;
        Moment now = X_Time.now();
        final Pointer success = new Pointer((Object)false);
        try {
            response = this.service().get("http://httpbin.org/get", null, (IOCallback)new DelegatingIOCallback((SuccessHandler)new SuccessHandler<IOMessage<String>>(){

                public void onSuccess(IOMessage<String> t) {
                    Assert.assertNotNull((Object)t.body());
                    Assert.assertNotSame((Object)0, (Object)((String)t.body()).length());
                    success.set((Object)true);
                }
            }));
        }
        catch (Throwable e) {
            if (X_Util.unwrap((Throwable)e) instanceof UnknownHostException) {
                return;
            }
            throw X_Util.rethrow((Throwable)e);
        }
        response.response();
        Assert.assertTrue((boolean)((Boolean)success.get()));
        System.out.println("Test took " + X_Time.difference((Moment)now));
    }

    @Test
    public void testPost() {
        IORequest response;
        Moment now = X_Time.now();
        final Pointer success = new Pointer((Object)false);
        try {
            response = this.service().post("http://httpbin.org/post", "test=success", null, (IOCallback)new DelegatingIOCallback((SuccessHandler)new SuccessHandler<IOMessage<String>>(){

                public void onSuccess(IOMessage<String> t) {
                    Assert.assertNotNull((Object)t.body());
                    Assert.assertNotSame((Object)0, (Object)((String)t.body()).length());
                    JSONObject asJson = new JSONObject((String)t.body());
                    success.set((Object)true);
                    X_Log.info((Object[])new Object[]{t.body()});
                    Assert.assertEquals((Object)"success", (Object)asJson.getJSONObject("form").getString("test"));
                }
            }));
        }
        catch (Throwable e) {
            if (X_Util.unwrap((Throwable)e) instanceof UnknownHostException) {
                return;
            }
            throw X_Util.rethrow((Throwable)e);
        }
        response.response();
        Assert.assertTrue((boolean)((Boolean)success.get()));
        System.out.println("Test took " + X_Time.difference((Moment)now));
    }

    @Test
    @Ignore(value="Use a local server instead of flaky jsontest.com")
    public void testHeaders() {
        IORequest response;
        Moment now = X_Time.now();
        final Pointer success = new Pointer((Object)false);
        try {
            StringDictionary headers = X_Collect.newDictionary();
            headers.setValue((Object)"test", (Object)"success");
            response = this.service().get("http://headers.jsontest.com", headers, (IOCallback)new DelegatingIOCallback((SuccessHandler)new SuccessHandler<IOMessage<String>>(){

                public void onSuccess(IOMessage<String> t) {
                    Assert.assertNotNull((Object)t.body());
                    Assert.assertNotSame((Object)0, (Object)((String)t.body()).length());
                    JSONObject asJson = new JSONObject((String)t.body());
                    Assert.assertEquals((Object)"success", (Object)asJson.getString("test"));
                    Assert.assertEquals((Object)"*", (Object)((IntTo)t.headers().get("Access-Control-Allow-Origin")).at(0));
                    success.set((Object)true);
                }
            }));
        }
        catch (Throwable e) {
            if (X_Util.unwrap((Throwable)e) instanceof UnknownHostException) {
                return;
            }
            throw X_Util.rethrow((Throwable)e);
        }
        response.response();
        Assert.assertTrue((boolean)((Boolean)success.get()));
        System.out.println("Test took " + X_Time.difference((Moment)now));
    }
}

