/*
 * Decompiled with CFR 0.152.
 */
package xapi.io.impl;

import xapi.collect.X_Collect;
import xapi.collect.api.Dictionary;
import xapi.collect.api.StringDictionary;
import xapi.except.NotYetImplemented;
import xapi.io.X_IO;
import xapi.io.api.IOCallback;
import xapi.io.api.IOMessage;
import xapi.io.api.IORequest;
import xapi.io.api.IORequestBuilder;
import xapi.io.service.IOService;
import xapi.log.X_Log;
import xapi.util.X_Runtime;
import xapi.util.X_String;
import xapi.util.api.ConvertsValue;
import xapi.util.api.ErrorHandler;
import xapi.util.api.Pointer;
import xapi.util.api.SuccessHandler;

public class IORequestBuilderDefault<V>
implements IORequestBuilder<V> {
    private int modifier;
    private String url;
    private ConvertsValue<String, V> deserializer;
    private ConvertsValue<V, String> serializer;
    private StringDictionary<String> headers = this.initHeaders();
    private V value;

    @Override
    public IORequest<V> send(final SuccessHandler<V> handler) {
        int modifer = this.modifier;
        final String url = this.url;
        final ConvertsValue<String, V> deserializer = this.deserializer;
        ConvertsValue<V, String> serializer = this.serializer;
        final StringDictionary<String> headerCopy = this.initHeaders();
        X_Collect.copyDictionary(this.headers, headerCopy);
        final Pointer result = new Pointer(this.value);
        final Pointer failure = new Pointer(null);
        IOService service = this.service();
        class IO
        implements IORequest<V> {
            boolean pending = true;
            boolean cancel = false;

            IO() {
            }

            @Override
            public boolean isPending() {
                return this.pending;
            }

            @Override
            public boolean isSuccess() {
                return !this.pending && !this.cancel && failure.get() == null;
            }

            @Override
            public void cancel() {
                this.cancel = true;
            }

            @Override
            public V response() {
                return result.get();
            }

            @Override
            public Dictionary<String, String> headers() {
                return headerCopy;
            }
        }
        final IO io = new IO();
        IOCallback<IOMessage<String>> callback = new IOCallback<IOMessage<String>>(){
            {
            }

            public void onSuccess(IOMessage<String> t) {
                io.pending = false;
                if (io.cancel) {
                    if (X_Runtime.isDebug()) {
                        X_Log.trace((Object[])new Object[]{"Ignoring cancelled message", t.url(), t.body()});
                    }
                    return;
                }
                if (deserializer == null) {
                    assert (X_String.isEmpty((String)t.body())) : "Non-null response without a deserializer instance for " + url + "\n Response: " + t.body();
                } else {
                    result.set(deserializer.convert((Object)t.body()));
                }
                if (handler != null) {
                    handler.onSuccess(result.get());
                }
            }

            public void onError(Throwable e) {
                failure.set((Object)e);
                io.pending = false;
                if (handler instanceof ErrorHandler) {
                    ((ErrorHandler)handler).onError(e);
                }
            }

            @Override
            public void onCancel() {
                io.cancel();
            }

            @Override
            public boolean isCancelled() {
                return io.cancel;
            }
        };
        switch (modifer) {
            case 4: {
                service.delete(url, headerCopy, callback);
                break;
            }
            case 0: {
                service.get(url, headerCopy, callback);
                break;
            }
            case 2: {
                service.post(url, (String)serializer.convert(this.value), headerCopy, callback);
                break;
            }
            case 3: {
                service.put(url, this.toBinary((String)serializer.convert(this.value)), headerCopy, callback);
                break;
            }
            case 1: 
            case 5: {
                throw new NotYetImplemented("");
            }
        }
        return io;
    }

    protected byte[] toBinary(String convert) {
        return X_String.getBytes((String)convert);
    }

    protected StringDictionary<String> initHeaders() {
        return X_Collect.newStringDictionary();
    }

    @Override
    public IOService service() {
        return X_IO.getIOService();
    }

    @Override
    public IORequestBuilder<V> setDeserializer(ConvertsValue<String, V> deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    @Override
    public IORequestBuilder<V> setSerializer(ConvertsValue<V, String> serializer) {
        this.serializer = serializer;
        return this;
    }

    @Override
    public IORequestBuilder<V> setUrl(String url) {
        this.url = url;
        return this;
    }

    @Override
    public IORequestBuilder<V> setHeader(String header, String value) {
        this.headers.setValue((Object)header, (Object)value);
        return this;
    }

    @Override
    public IORequestBuilder<V> setModifier(int modifier) {
        this.modifier = modifier;
        return this;
    }

    @Override
    public IORequestBuilder<V> setValue(V value) {
        this.value = value;
        return this;
    }
}

