/*
 * Decompiled with CFR 0.152.
 */
package xapi.io.api;

import xapi.collect.api.Fifo;
import xapi.collect.impl.SimpleFifo;
import xapi.io.api.LineReader;
import xapi.log.X_Log;
import xapi.util.X_String;

public class StringReader
implements LineReader {
    private StringBuilder b;
    private final Fifo<LineReader> delegates = new SimpleFifo();
    boolean finished;

    @Override
    public void onStart() {
        this.b = new StringBuilder();
        if (this.delegates.isEmpty()) {
            return;
        }
        for (LineReader delegate : this.delegates.forEach()) {
            delegate.onStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLine(String line) {
        StringReader stringReader = this;
        synchronized (stringReader) {
            this.b.append(line);
            if (this.delegates.isEmpty()) {
                return;
            }
            for (LineReader delegate : this.delegates.forEach()) {
                delegate.onLine(line);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onEnd() {
        X_Log.trace((Object[])new Object[]{this.getClass(), "ending", this});
        try {
            for (LineReader delegate : this.delegates.forEach()) {
                X_Log.debug((Object[])new Object[]{this.getClass(), "ending delegate", delegate.getClass(), delegate});
                delegate.onEnd();
            }
        }
        finally {
            this.finished = true;
            this.onEnd0();
        }
        Fifo<LineReader> fifo = this.delegates;
        synchronized (fifo) {
            this.delegates.notifyAll();
        }
    }

    protected void onEnd0() {
    }

    public String toString() {
        return String.valueOf(this.b);
    }

    public synchronized void forwardTo(LineReader callback) {
        X_Log.debug((Object[])new Object[]{this.getClass(), this.getClass().getName(), "forwardingTo", callback.getClass().getName(), ":", callback});
        if (this.b != null) {
            callback.onStart();
            for (String line : X_String.splitNewLine((String)this.b.toString())) {
                callback.onLine(line);
            }
        }
        this.delegates.give((Object)callback);
        if (this.finished) {
            callback.onEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToEnd() throws InterruptedException {
        if (this.finished) {
            return;
        }
        Fifo<LineReader> fifo = this.delegates;
        synchronized (fifo) {
            this.delegates.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToEnd(long timeout, int nanos) throws InterruptedException {
        if (this.finished) {
            return;
        }
        Fifo<LineReader> fifo = this.delegates;
        synchronized (fifo) {
            this.delegates.wait(timeout, nanos);
        }
    }
}

