/*
 * Decompiled with CFR 0.152.
 */
package xapi.io.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import xapi.annotation.inject.InstanceDefault;
import xapi.annotation.inject.SingletonDefault;
import xapi.collect.X_Collect;
import xapi.collect.api.ClassTo;
import xapi.collect.api.StringDictionary;
import xapi.io.api.IOCallback;
import xapi.io.api.IOMessage;
import xapi.io.api.IORequestBuilder;
import xapi.io.api.LineReader;
import xapi.io.api.StringReader;
import xapi.io.impl.IORequestBuilderDefault;
import xapi.io.service.IOService;
import xapi.log.X_Log;
import xapi.util.X_Properties;
import xapi.util.api.ConvertsValue;
import xapi.util.api.ReceivesValue;
import xapi.util.api.RemovalHandler;

@InstanceDefault(implFor=IOService.class)
@SingletonDefault(implFor=IOService.class)
public class IOServiceDefault
implements IOService {
    private static final Class<ConvertsValue<?, String>> SERIAL_CLASS = (Class)Class.class.cast(ConvertsValue.class);
    private static final Class<ConvertsValue<String, ?>> DESERIAL_CLASS = (Class)Class.class.cast(ConvertsValue.class);
    private final ClassTo<ConvertsValue<?, String>> serializers = X_Collect.newClassMap(SERIAL_CLASS);
    private final ClassTo<ConvertsValue<String, ?>> deserializers = X_Collect.newClassMap(DESERIAL_CLASS);

    @Override
    public <V> IORequestBuilder<V> request(Class<V> classLit, String id) {
        return new IORequestBuilderDefault().setUrl(this.toUrl(classLit, id)).setDeserializer((ConvertsValue)ConvertsValue.class.cast(this.deserializers.get(classLit))).setSerializer((ConvertsValue)ConvertsValue.class.cast(this.serializers.get(classLit)));
    }

    @Override
    public <V> RemovalHandler registerParser(final Class<V> classLit, final ConvertsValue<V, String> serializer, final ConvertsValue<String, V> deserializer) {
        final ConvertsValue currentSerializer = (ConvertsValue)this.serializers.put(classLit, serializer);
        final ConvertsValue currentDeserialize = (ConvertsValue)this.deserializers.put(classLit, deserializer);
        return new RemovalHandler(){

            public void remove() {
                if (IOServiceDefault.this.serializers.get((Object)classLit) == serializer) {
                    IOServiceDefault.this.serializers.put((Object)classLit, (Object)currentSerializer);
                }
                if (IOServiceDefault.this.deserializers.get((Object)classLit) == deserializer) {
                    IOServiceDefault.this.deserializers.put((Object)classLit, (Object)currentDeserialize);
                }
            }
        };
    }

    @Override
    public void put(String url, byte[] body, StringDictionary<String> headers, IOCallback<IOMessage<String>> callback) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(String uri, final StringDictionary<String> headers, IOCallback<IOMessage<String>> callback) {
        final String url = this.normalize(uri);
        if (callback.isCancelled()) {
            return;
        }
        try {
            String result;
            URL asUrl = new URL(url);
            final URLConnection connect = asUrl.openConnection();
            connect.setDoInput(true);
            connect.setDoOutput(false);
            if (headers != null) {
                headers.forKeys((ReceivesValue)new ReceivesValue<String>(){

                    public void set(String key) {
                        String value = (String)headers.getValue((Object)key);
                        connect.setRequestProperty(key, value);
                    }
                });
            }
            this.applySettings(connect, 0);
            try (InputStream in = connect.getInputStream();){
                result = this.drainInput(in, callback);
            }
            callback.onSuccess(new IOMessage<String>(){
                StringDictionary<String> headers;

                @Override
                public String body() {
                    return result;
                }

                @Override
                public int modifier() {
                    return 0;
                }

                @Override
                public String url() {
                    return url;
                }

                @Override
                public StringDictionary<String> headers() {
                    if (this.headers == null) {
                        this.headers = X_Collect.newStringDictionary();
                    }
                    return this.headers;
                }
            });
        }
        catch (Throwable e) {
            callback.onError(e);
            X_Log.warn((Object[])new Object[]{"IO Error", e});
        }
    }

    private String uriBase() {
        String port = X_Properties.getProperty((String)"xapi.server.port", (String)"");
        return System.getProperty("xapi.server.host", "0.0.0.0") + (port.length() == 0 ? "" : ":" + port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String drainInput(InputStream in, IOCallback<IOMessage<String>> callback) throws IOException {
        try {
            String line;
            BufferedReader read = new BufferedReader(new InputStreamReader(in));
            StringReader messageReader = new StringReader();
            if (callback instanceof LineReader) {
                messageReader.forwardTo((LineReader)((Object)callback));
            }
            messageReader.onStart();
            while ((line = read.readLine()) != null) {
                messageReader.onLine(line);
            }
            String message = messageReader.toString();
            messageReader.onEnd();
            String string = message;
            return string;
        }
        finally {
            in.close();
        }
    }

    protected void applySettings(URLConnection connect, int modifiers) {
    }

    protected String normalize(String uri) {
        if (uri.charAt(0) == '/') {
            uri = this.uriBase();
        }
        if (!uri.contains("://")) {
            uri = "http://" + uri;
        }
        return uri;
    }

    protected String toUrl(Class<?> classLit, String id) {
        return id;
    }

    @Override
    public void post(String url, String body, StringDictionary<String> headers, IOCallback<IOMessage<String>> callback) {
    }

    @Override
    public void delete(String url, StringDictionary<String> headers, IOCallback<IOMessage<String>> callback) {
    }
}

