/*
 * Decompiled with CFR 0.152.
 */
package xapi.io.api;

import xapi.collect.api.Fifo;
import xapi.collect.impl.SimpleFifo;
import xapi.io.api.LineReader;
import xapi.util.X_String;

public class StringReader
implements LineReader {
    private StringBuilder b;
    private Fifo<LineReader> delegates = new SimpleFifo();

    @Override
    public void onStart() {
        this.b = new StringBuilder();
        if (this.delegates.isEmpty()) {
            return;
        }
        for (LineReader delegate : this.delegates.forEach()) {
            delegate.onStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLine(String line) {
        StringReader stringReader = this;
        synchronized (stringReader) {
            this.b.append(line);
            this.b.append('\n');
            if (this.delegates.isEmpty()) {
                return;
            }
            for (LineReader delegate : this.delegates.forEach()) {
                delegate.onLine(line);
            }
        }
    }

    @Override
    public void onEnd() {
        this.b = null;
        if (this.delegates.isEmpty()) {
            return;
        }
        for (LineReader delegate : this.delegates.forEach()) {
            delegate.onEnd();
        }
    }

    public String toString() {
        return String.valueOf(this.b);
    }

    public synchronized void forwardTo(LineReader callback) {
        if (this.b == null) {
            this.delegates.give((Object)callback);
        } else {
            callback.onStart();
            for (String line : X_String.splitNewLine((String)this.b.toString())) {
                callback.onLine(line);
            }
            this.delegates.give((Object)callback);
        }
    }
}

