/*
 * Decompiled with CFR 0.152.
 */
package xapi.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Provider;
import xapi.inject.X_Inject;
import xapi.io.api.HasLiveness;
import xapi.io.api.StringReader;
import xapi.io.service.IOService;
import xapi.log.X_Log;
import xapi.log.api.LogLevel;
import xapi.time.X_Time;
import xapi.time.api.Moment;
import xapi.util.api.ErrorHandler;

public class X_IO {
    private static final Provider<IOService> service = X_Inject.singletonLazy(IOService.class);

    public static IOService getIOService() {
        return (IOService)service.get();
    }

    public static void drain(final LogLevel info, final InputStream in, final StringReader successHandler, final HasLiveness liveCheck) {
        final ByteArrayOutputStream buffer = new ByteArrayOutputStream(4096);
        if (!liveCheck.isAlive()) {
            X_Log.trace((Object[])new Object[]{"Trying to drain a dead process", liveCheck});
            return;
        }
        X_IO.start(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block12: {
                    boolean log = info != null && X_Log.loggable((LogLevel)info);
                    int delay = 50;
                    int read = 1;
                    int loops = 20000;
                    try {
                        block5: while (read >= 0 && loops-- > 0) {
                            X_Time.trySleep((int)5, (int)0);
                            Moment start = X_Time.now();
                            do {
                                int avail;
                                if ((avail = in.available()) == 0 && !liveCheck.isAlive()) {
                                    X_Log.debug((Object[])new Object[]{"Stream not alive; bailing"});
                                    break block5;
                                }
                                byte[] bytes = new byte[Math.min(1024, avail)];
                                read = in.read(bytes);
                                if (read > 0) {
                                    delay = 20;
                                    buffer.write(bytes, 0, read);
                                    bytes = null;
                                    String asStr = new String(buffer.toByteArray(), "UTF-8");
                                    if (!log || asStr.trim().length() <= 0) continue;
                                    X_Log.log((LogLevel)info, (Object)asStr);
                                    continue;
                                }
                                X_Time.trySleep((int)(delay *= 2), (int)0);
                                continue block5;
                            } while (X_Time.now().millis() - start.millis() < 100.0);
                        }
                        if (read < 1) {
                            successHandler.onLine(new String(buffer.toByteArray(), "UTF-8"));
                            break block12;
                        }
                        throw new RuntimeException("Input stream not cleared " + read + "; left: |" + new String(buffer.toByteArray()) + "|");
                    }
                    catch (Exception e) {
                        if (successHandler instanceof ErrorHandler) {
                            ((ErrorHandler)successHandler).onError((Throwable)e);
                        } else {
                            X_Log.error((Object[])new Object[]{"Error draining input stream", info, in, e});
                        }
                    }
                    finally {
                        successHandler.onEnd();
                        X_IO.close(in);
                    }
                }
            }
        });
    }

    private static void start(Runnable runnable) {
        new Thread(runnable).start();
    }

    public static void close(InputStream in) {
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

