/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.processor;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import xapi.util.api.Pair;
import xapi.util.impl.AbstractPair;
import xapi.util.impl.PairBuilder;

@SupportedAnnotationTypes(value={"xapi.annotation.inject.*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class InjectionAnnotationProcessor
extends AbstractProcessor {
    protected Filer filer;
    protected ManifestWriter writer;

    @Override
    public final synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
        this.writer = this.initWriter(processingEnv);
    }

    protected ManifestWriter initWriter(ProcessingEnvironment processingEnv) {
        return new ManifestWriter();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Elements elements = this.processingEnv.getElementUtils();
        for (TypeElement typeElement : annotations) {
            ExecutableElement implFor = this.extractImplFor(typeElement);
            ExecutableElement priorityFor = this.extractPriorityFor(typeElement);
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                AnnotationMirror mirror = this.getMirror(element, typeElement);
                AnnotationValue t = elements.getElementValuesWithDefaults(mirror).get(implFor);
                if (!(t.getValue() instanceof DeclaredType)) continue;
                DeclaredType cls = (DeclaredType)t.getValue();
                Integer priority = this.getPriority(elements, mirror, priorityFor);
                if (typeElement.getSimpleName().contentEquals("SingletonDefault")) {
                    for (String platform : this.getPlatforms(element)) {
                        this.writer.writeSingleton(cls.toString(), platform, null, element.toString());
                    }
                    continue;
                }
                if (typeElement.getSimpleName().contentEquals("SingletonOverride")) {
                    for (String platform : this.getPlatforms(element)) {
                        this.writer.writeSingleton(cls.toString(), platform, priority, element.toString());
                    }
                    continue;
                }
                if (typeElement.getSimpleName().contentEquals("InstanceDefault")) {
                    for (String platform : this.getPlatforms(element)) {
                        this.writer.writeInstance(cls.toString(), platform, null, element.toString());
                    }
                    continue;
                }
                if (!typeElement.getSimpleName().contentEquals("InstanceOverride")) continue;
                for (String platform : this.getPlatforms(element)) {
                    this.writer.writeInstance(cls.toString(), platform, priority, element.toString());
                }
            }
        }
        if (roundEnv.processingOver()) {
            try {
                this.writer.commit(this.filer);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Unable to write injection metadata.");
                return false;
            }
        }
        return true;
    }

    private Integer getPriority(Elements elements, AnnotationMirror mirror, ExecutableElement priorityFor) {
        if (priorityFor == null) {
            return null;
        }
        return (Integer)elements.getElementValuesWithDefaults(mirror).get(priorityFor).getValue();
    }

    private AnnotationMirror getMirror(Element element, TypeElement type) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(type.toString())) continue;
            return annotationMirror;
        }
        throw new RuntimeException("Element " + element + " did not contain annotation " + type);
    }

    private ExecutableElement extractImplFor(TypeElement anno) {
        for (ExecutableElement e : ElementFilter.methodsIn(anno.getEnclosedElements())) {
            if (!e.getSimpleName().toString().equals("implFor")) continue;
            return e;
        }
        throw new RuntimeException("Annotation " + anno + " does not contain an implFor() method.\n" + "Available methods: " + anno.getEnclosedElements());
    }

    private ExecutableElement extractPriorityFor(TypeElement anno) {
        for (ExecutableElement e : ElementFilter.methodsIn(anno.getEnclosedElements())) {
            if (!e.getSimpleName().toString().equals("priority")) continue;
            return e;
        }
        return null;
    }

    protected Iterable<String> getPlatforms(Element element) {
        return Arrays.asList("");
    }

    void dumpType(Element anno) {
        this.processingEnv.getElementUtils().printElements(new PrintWriter(System.out), anno);
    }

    protected static class ManifestWriter {
        HashMap<String, Pair<Integer, String>> singletons = new HashMap();
        HashMap<String, Pair<Integer, String>> instances = new HashMap();

        protected ManifestWriter() {
        }

        void writeSingleton(String iface, String platform, Integer priority, String element) {
            if (priority == null) {
                if (!this.singletons.containsKey(iface)) {
                    this.singletons.put(iface, PairBuilder.pairOf(priority, element));
                }
            } else {
                Pair<Integer, String> existing = this.singletons.get(iface);
                if (existing == null || existing.get0() == null || existing.get0() < priority) {
                    this.singletons.put(iface, PairBuilder.pairOf(priority, element));
                }
            }
        }

        void writeInstance(String iface, String platform, Integer priority, String element) {
            if (priority == null) {
                if (!this.instances.containsKey(iface)) {
                    this.instances.put(iface, PairBuilder.pairOf(priority, element));
                }
            } else {
                Pair<Integer, String> existing = this.instances.get(iface);
                if (existing == null || existing.get0() == null || existing.get0() < priority) {
                    this.instances.put(iface, PairBuilder.pairOf(priority, element));
                }
            }
        }

        void commit(Filer filer) throws IOException {
            String impl;
            for (String iface : this.singletons.keySet()) {
                impl = this.singletons.get(iface).get1();
                this.writeTo("singletons", iface, impl, filer);
            }
            for (String iface : this.instances.keySet()) {
                impl = this.instances.get(iface).get1();
                this.writeTo("instances", iface, impl, filer);
            }
        }

        protected void writeTo(String location, String iface, String impl, Filer filer) throws IOException {
            String manifest = "META-INF/" + location + "/" + iface;
            try {
                CharSequence existing = filer.getResource(StandardLocation.CLASS_OUTPUT, "", manifest).getCharContent(true);
                if (!impl.contentEquals(existing)) {
                    System.out.println("Cannot overwrite existing " + location + " injection target.\n" + "Tried: " + iface + " -> " + impl + "\n" + "but existing manifest has: " + existing);
                }
            }
            catch (FilerException filerException) {
            }
            catch (IOException e) {
                FileObject res = filer.createResource(StandardLocation.CLASS_OUTPUT, "", manifest, new Element[0]);
                OutputStream out = res.openOutputStream();
                out.write(impl.getBytes());
                out.close();
            }
        }
    }

    protected static class PlatformPair
    extends AbstractPair<String, Class<?>> {
        protected PlatformPair() {
        }
    }
}

