/*
 * Decompiled with CFR 0.152.
 */
package xapi.dev.processor;

import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import xapi.annotation.reflect.MirroredAnnotation;
import xapi.collect.impl.SimpleFifo;
import xapi.dev.processor.AnnotationManifest;
import xapi.dev.source.ClassBuffer;
import xapi.dev.source.FieldBuffer;
import xapi.dev.source.MethodBuffer;
import xapi.dev.source.SourceBuilder;

@SupportedAnnotationTypes(value={"xapi.annotation.reflect.MirroredAnnotation"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class AnnotationMirrorProcessor
extends AbstractProcessor {
    private final HashMap<String, AnnotationManifest> generatedMirrors = new HashMap();
    protected Filer filer;
    private TypeMirror annoType;
    private TypeMirror stringType;
    private TypeMirror classType;
    private TypeMirror enumType;

    @Override
    public final synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
        Elements elements = processingEnv.getElementUtils();
        Types types = processingEnv.getTypeUtils();
        this.annoType = elements.getTypeElement(Annotation.class.getName()).asType();
        this.stringType = elements.getTypeElement(String.class.getName()).asType();
        this.classType = types.erasure(elements.getTypeElement(Class.class.getName()).asType());
        this.enumType = types.erasure(elements.getTypeElement(Enum.class.getName()).asType());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                MirroredAnnotation mirrorSettings = element.getAnnotation(MirroredAnnotation.class);
                AnnotationManifest manifest = this.addAnnotation((TypeElement)element);
                if (mirrorSettings.generateJavaxLangModelFactory()) {
                    this.generateJavaxFactory((TypeElement)element, manifest);
                }
                if (mirrorSettings.generateXapiBytecodeFactory()) {
                    this.generateXapiFactory((TypeElement)element, manifest);
                }
                if (!mirrorSettings.generateReflectionFactory()) continue;
            }
        }
        for (String string : this.generatedMirrors.keySet().toArray(new String[this.generatedMirrors.size()])) {
            try {
                AnnotationManifest mirror = this.generatedMirrors.get(string);
                if (mirror == null) continue;
                String code = mirror.generated;
                this.log("Generating " + string);
                String genClass = string + "Builder";
                try {
                    int ind = genClass.lastIndexOf(46);
                    String pkg = genClass.substring(0, ind);
                    String name = genClass.substring(ind + 1) + ".class";
                    FileObject file = this.filer.getResource(StandardLocation.CLASS_OUTPUT, pkg, name);
                    CharSequence content = file.getCharContent(true);
                    if (code.equals(content.toString())) continue;
                    file.delete();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                JavaFileObject src = this.filer.createSourceFile(genClass, new Element[0]);
                Writer out = src.openWriter();
                out.write(code);
                this.generatedMirrors.put(string, null);
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log("Unable to write annotation reflection for " + string + ";");
            }
        }
        return roundEnv.processingOver();
    }

    private void generateJavaxFactory(TypeElement el, AnnotationManifest manifest) {
    }

    private void generateXapiFactory(TypeElement el, AnnotationManifest manifest) {
    }

    private AnnotationManifest addAnnotation(TypeElement element) {
        String annoName = element.getQualifiedName().toString();
        if (this.generatedMirrors.containsKey(annoName)) {
            return this.generatedMirrors.get(annoName);
        }
        AnnotationManifest manifest = new AnnotationManifest(annoName);
        this.generatedMirrors.put(annoName, manifest);
        PackageElement pkg = this.processingEnv.getElementUtils().getPackageOf(element);
        String simpleName = element.getSimpleName().toString();
        String builderName = simpleName + "Builder";
        SourceBuilder sb = new SourceBuilder("public class " + builderName);
        ClassBuffer annoBuilder = sb.getClassBuffer();
        if (!pkg.isUnnamed()) {
            sb.setPackage(pkg.getQualifiedName().toString());
        }
        ClassBuffer immutableAnno = (ClassBuffer)((ClassBuffer)annoBuilder.addAnnotation("@SuppressWarnings(\"all\")")).createInnerClass("private static class Immutable" + simpleName).addInterfaces(new String[]{annoName}).makeFinal();
        immutableAnno.createMethod("public Class<? extends java.lang.annotation.Annotation> annotationType()").returnValue(annoName + ".class");
        SimpleFifo<String> requiredFields = new SimpleFifo<String>();
        SimpleFifo<String> ctorParams = new SimpleFifo<String>();
        Types types = this.processingEnv.getTypeUtils();
        block8: for (ExecutableElement method : ElementFilter.methodsIn(element.getEnclosedElements())) {
            String fieldName = method.getSimpleName().toString();
            AnnotationValue dflt = method.getDefaultValue();
            TypeMirror returnMirror = method.getReturnType();
            manifest.addMethod(method.getSimpleName(), returnMirror, dflt);
            FieldBuffer annoField = annoBuilder.createField(returnMirror.toString(), method.getSimpleName().toString(), 2);
            annoField.addGetter(17);
            annoField.addSetter(17);
            FieldBuffer field = immutableAnno.createField(returnMirror.toString(), method.getSimpleName().toString(), 18).setExactName(true);
            field.addGetter(17);
            String param = field.getSimpleType() + " " + field.getName();
            ctorParams.give(param);
            if (dflt == null) {
                requiredFields.give(param);
            }
            block0 : switch (returnMirror.getKind()) {
                case DECLARED: {
                    if (types.isAssignable(returnMirror, this.annoType)) {
                        this.addAnnotation((TypeElement)((DeclaredType)returnMirror).asElement());
                        if (dflt != null) {
                            AnnotationMirror annotationMirror = (AnnotationMirror)dflt.getValue();
                        }
                        manifest.setAnnoType(annoName, fieldName);
                        break;
                    }
                    if (!types.isAssignable(returnMirror, this.classType) && !types.isAssignable(returnMirror, this.stringType) && !types.isAssignable(returnMirror, this.enumType)) continue block8;
                    break;
                }
                case ARRAY: {
                    TypeMirror component = ((ArrayType)returnMirror).getComponentType();
                    if (types.isAssignable(component, this.annoType)) {
                        this.addAnnotation((TypeElement)((DeclaredType)component).asElement());
                        break;
                    }
                    if (types.isAssignable(component, this.classType) || types.isAssignable(component, this.stringType) || types.isAssignable(component, this.enumType)) break;
                    switch (component.getKind()) {
                        case BOOLEAN: 
                        case BYTE: 
                        case CHAR: 
                        case SHORT: 
                        case INT: 
                        case FLOAT: 
                        case LONG: 
                        case DOUBLE: {
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("Unsupported type: " + component + " of " + method);
                }
                case BOOLEAN: 
                case BYTE: 
                case CHAR: 
                case SHORT: 
                case INT: 
                case FLOAT: 
                case LONG: 
                case DOUBLE: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type: " + returnMirror + " of " + method);
                }
            }
        }
        if (requiredFields.size() == 0) {
            annoBuilder.createMethod("public static " + builderName + " build" + simpleName + "()").returnValue("new " + builderName + "()");
            annoBuilder.createMethod("private " + builderName + "()");
        } else {
            SimpleFifo<String> joinable = new SimpleFifo<String>();
            MethodBuffer ctor = annoBuilder.createMethod("private " + builderName + "(" + requiredFields.join(", ") + ")");
            for (String field : requiredFields.forEach()) {
                field = field.substring(field.lastIndexOf(32) + 1);
                joinable.give(field);
                ctor.println("this." + field + " = " + field + ";");
            }
            annoBuilder.createMethod("public static " + builderName + " build" + simpleName + "(" + requiredFields.join(", ") + ")").returnValue("new " + builderName + "(" + joinable.join(", ") + ")");
        }
        if (ctorParams.size() > 0) {
            MethodBuffer ctor = immutableAnno.createMethod("private " + immutableAnno.getSimpleName() + "()");
            MethodBuffer build = annoBuilder.createMethod("public " + simpleName + " build()");
            SimpleFifo<String> fieldRefs = new SimpleFifo<String>();
            for (String param : ctorParams.forEach()) {
                int end = param.lastIndexOf(32);
                ctor.addParameters(new String[]{param});
                String paramName = param.substring(end + 1);
                fieldRefs.give(paramName);
                ctor.println("this." + paramName + " = " + paramName + ";");
            }
            build.returnValue("new Immutable" + simpleName + "(" + fieldRefs.join(", ") + ")");
        }
        this.log(sb.toString());
        manifest.generated = sb.toString();
        return manifest;
    }

    private void log(String string) {
        System.out.println(string);
    }
}

