/*
 * Decompiled with CFR 0.152.
 */
package xapi.test.util;

import org.junit.Assert;
import org.junit.Test;
import xapi.util.validators.ChecksValidEmail;

public class ValidatorTest {
    @Test
    public void testValidEmail() {
        String error = ChecksValidEmail.SINGLETON.validate("test.user@domain.com", "");
        Assert.assertNull((Object)error);
    }

    @Test
    public void testInvalidUsername() {
        String error = ChecksValidEmail.SINGLETON.validate("test. user@domain.com", "");
        Assert.assertEquals((Object)error, (Object)"[username can only contain letter, numbers and . _ or - ] You sent: test. user@domain.com");
    }

    @Test
    public void testInvalidDomain() {
        String error = ChecksValidEmail.SINGLETON.validate("test.user@doma&in.com", "");
        Assert.assertEquals((Object)error, (Object)"[domain name can only contain letter, numbers and . or - ] You sent: test.user@doma&in.com");
    }

    @Test
    public void testDomainMissingTld() {
        String error = ChecksValidEmail.SINGLETON.validate("test.user@domaincom", "");
        Assert.assertEquals((Object)error, (Object)"[domain name must contain a . ] You sent: test.user@domaincom");
    }

    @Test
    public void testNoUsername() {
        String error = ChecksValidEmail.SINGLETON.validate("@domain.com", "");
        Assert.assertEquals((Object)error, (Object)"[value cannot start with @] You sent: @domain.com");
    }

    @Test
    public void testNoAtSign() {
        String error = ChecksValidEmail.SINGLETON.validate("test.user-domain.com", "");
        Assert.assertEquals((Object)error, (Object)"[value must contain @] +You sent: test.user-domain.com");
    }
}

