/*
 * Decompiled with CFR 0.152.
 */
package xapi.test.collect;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import xapi.collect.api.Fifo;
import xapi.collect.impl.SimpleFifo;

public class FifoTest {
    @Test
    public void testAdd() {
        SimpleFifo fifo = new SimpleFifo();
        ArrayList list = new ArrayList();
        this.doAdd((Fifo)fifo, list, (Object)"one");
        this.doAdd((Fifo)fifo, list, (Object)"two");
        this.doAdd((Fifo)fifo, list, (Object)"three");
        Assert.assertEquals((Object)fifo.take(), list.get(0));
        Assert.assertEquals((Object)fifo.take(), list.get(1));
        Assert.assertEquals((Object)fifo.take(), list.get(2));
        Assert.assertTrue((boolean)fifo.isEmpty());
        for (String item : fifo.forEach()) {
            assert (false) : "Fifo not empty: " + item + " was leftover";
        }
    }

    @Test
    public void testRemove() {
        SimpleFifo fifo = new SimpleFifo();
        ArrayList list = new ArrayList();
        fifo.give((Object)"four");
        this.doAdd((Fifo)fifo, list, (Object)"one");
        this.doAdd((Fifo)fifo, list, (Object)"two");
        this.doAdd((Fifo)fifo, list, (Object)"three");
        this.doAdd((Fifo)fifo, list, (Object)"four");
        this.doRemove((Fifo)fifo, list, (Object)"three");
        this.doRemove((Fifo)fifo, list, (Object)"four");
        int pos = 0;
        for (String item : fifo.forEach()) {
            String other = (String)list.get(pos);
            Assert.assertEquals((Object)item, (Object)other);
            ++pos;
        }
        Assert.assertEquals((Object)fifo.take(), list.get(0));
        Assert.assertEquals((Object)fifo.take(), list.get(1));
        Assert.assertTrue((boolean)fifo.isEmpty());
        for (String item : fifo.forEach()) {
            assert (false) : "Fifo not empty: " + item + " was leftover";
        }
    }

    private void dump(Fifo<String> fifo) {
        for (String item : fifo.forEach()) {
            System.out.println(item);
        }
    }

    @Test
    public void testIterate() {
        SimpleFifo fifo = new SimpleFifo();
        ArrayList list = new ArrayList();
        this.doAdd((Fifo)fifo, list, (Object)"one");
        this.doAdd((Fifo)fifo, list, (Object)"two");
        this.doAdd((Fifo)fifo, list, (Object)"three");
        this.doAdd((Fifo)fifo, list, (Object)"four");
        this.doRemove((Fifo)fifo, list, (Object)"three");
        this.doAdd((Fifo)fifo, list, (Object)"five");
        int pos = 0;
        for (String item : fifo.forEach()) {
            String other = (String)list.get(pos);
            Assert.assertEquals((Object)item, (Object)other);
            ++pos;
        }
        Assert.assertEquals((long)fifo.size(), (long)list.size());
    }

    @Test
    public void testIterateRemove() {
        SimpleFifo fifo = new SimpleFifo();
        LinkedList list = new LinkedList();
        this.doAdd((Fifo)fifo, list, (Object)"one");
        this.doAdd((Fifo)fifo, list, (Object)"two");
        this.doAdd((Fifo)fifo, list, (Object)"three");
        this.doAdd((Fifo)fifo, list, (Object)"four");
        this.doAdd((Fifo)fifo, list, (Object)"five");
        list.remove("four");
        list.remove("five");
        Iterator iter = fifo.iterator();
        while (iter.hasNext()) {
            String next = (String)iter.next();
            if ("four".equals(next)) {
                iter.remove();
            }
            if (!"five".equals(next)) continue;
            iter.remove();
        }
        int pos = 0;
        for (String item : fifo.forEach()) {
            String other = (String)list.get(pos);
            Assert.assertEquals((Object)item, (Object)other);
            ++pos;
        }
        Assert.assertEquals((long)fifo.size(), (long)list.size());
    }

    @Test
    public void testIterateRemoveAll() {
        SimpleFifo fifo = new SimpleFifo();
        fifo.give((Object)"one").give((Object)"two").give((Object)"three").give((Object)"four");
        Iterator iter = fifo.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
        Assert.assertEquals((long)0L, (long)fifo.size());
        if (fifo.iterator().hasNext()) {
            throw new RuntimeException("Fifo not empty");
        }
        if (fifo.take() != null) {
            throw new RuntimeException("Fifo not empty");
        }
    }

    private <X> void doAdd(Fifo<X> fifo, List<X> list, X value) {
        fifo.give(value);
        list.add(value);
    }

    private <X> void doRemove(Fifo<X> fifo, List<X> list, X value) {
        fifo.remove(value);
        list.remove(value);
    }
}

