/*
 * Decompiled with CFR 0.152.
 */
package xapi.util.impl;

import xapi.collect.api.Fifo;
import xapi.collect.impl.SimpleFifo;
import xapi.util.api.ReceivesValue;
import xapi.util.impl.ReceivesMultiValue;

public class ReceivesPrioritizedValue<T>
extends ReceivesMultiValue<T> {
    final Fifo<ReceivesValue<T>> pre = new SimpleFifo<ReceivesValue<T>>();
    final Fifo<ReceivesValue<T>> post = new SimpleFifo<ReceivesValue<T>>();

    public void addPre(ReceivesValue<T> receiver) {
        assert (receiver != null) : "Do not send null receivers to " + this + "; (ReceivesMultiValue.addBefore) ";
        assert (receiver != this) : "Do not send a ReceivesMultiValue to itself.  Class: " + this + ";";
        this.pre.give(receiver);
    }

    public void addPost(ReceivesValue<T> receiver) {
        assert (receiver != null) : "Do not send null receivers to " + this + "; (ReceivesMultiValue.addAfter) ";
        assert (receiver != this) : "Do not send a ReceivesMultiValue to itself.  Class: " + this + ";";
        this.post.give(receiver);
    }

    @Override
    public void set(T value) {
        for (ReceivesValue<T> receivesValue : this.pre.forEach()) {
            receivesValue.set(value);
        }
        for (ReceivesValue<Object> receivesValue : this.handlers.forEach()) {
            receivesValue.set(value);
        }
        for (ReceivesValue<Object> receivesValue : this.post.forEach()) {
            receivesValue.set(value);
        }
    }

    @Override
    public void clearReceivers() {
        super.clearReceivers();
        this.post.clear();
        this.pre.clear();
    }

    @Override
    public void removeReceiver(ReceivesValue<T> receiver) {
        super.removeReceiver(receiver);
        this.pre.remove(receiver);
        this.post.remove(receiver);
    }
}

