/*
 * Decompiled with CFR 0.152.
 */
package xapi.util.impl;

import xapi.annotation.inject.SingletonDefault;
import xapi.collect.api.CharPool;
import xapi.collect.impl.MultithreadedStringTrie;
import xapi.except.NotYetImplemented;
import xapi.util.impl.Chars;

@SingletonDefault(implFor=CharPool.class)
public class CharPoolTrie
extends MultithreadedStringTrie<char[]>
implements CharPool {
    @Override
    public char[] getArray(char[] src) {
        if (src.length == 0) {
            return CharPool.EMPTY_STRING;
        }
        return (char[])this.get(src, 0, src.length);
    }

    @Override
    public char[] getArray(char[] src, int start, int len) {
        if (start == 0 && len == 0) {
            return CharPool.EMPTY_STRING;
        }
        return (char[])this.get(src, start, len);
    }

    @Override
    public char[] getArray(CharSequence src) {
        int len = src.length();
        if (len == 0) {
            return CharPool.EMPTY_STRING;
        }
        return this.getArray(src, 0, len);
    }

    @Override
    public char[] getArray(CharSequence src, int start, int len) {
        if (src instanceof Chars) {
            return (char[])super.get((Chars)src, start, len);
        }
        if (src instanceof String) {
            if (start == 0 && len == src.length()) {
                return (char[])super.get((String)src);
            }
            char[] key = new char[len - start];
            ((String)src).getChars(start, start + len, key, 0);
            return (char[])super.get(key);
        }
        throw new NotYetImplemented("CharPoolTrie only accepts String and Chars for CharSequence.  You sent " + src + "; a " + src.getClass());
    }

    @Override
    protected char[] onEmpty(MultithreadedStringTrie.Edge e, Chars key, int pos, int end) {
        assert (pos < end);
        char[] singleton = new char[end - pos];
        char[] keys = key.getChars();
        System.arraycopy(keys, key.start + pos, singleton, 0, singleton.length);
        this.doPut(e, keys, key.start + pos, key.start + end, singleton);
        return singleton;
    }
}

