/*
 * Decompiled with CFR 0.152.
 */
package xapi.log.impl;

import xapi.collect.api.Fifo;
import xapi.collect.impl.SimpleFifo;
import xapi.log.api.LogLevel;
import xapi.log.api.LogService;

public abstract class AbstractLog
implements LogService {
    protected LogLevel logLevel;

    @Override
    public boolean shouldLog(LogLevel logLevel) {
        return this.logLevel.ordinal() < logLevel.ordinal();
    }

    @Override
    public void log(LogLevel level, Object o) {
        if (this.shouldLog(level)) {
            Fifo<Object> arr = this.newFifo();
            arr.give(this.unwrap(o));
            this.doLog(level, arr);
        }
    }

    @Override
    public Fifo<Object> newFifo() {
        return new SimpleFifo<Object>();
    }

    @Override
    public Object unwrap(Object m) {
        if (m instanceof Throwable) {
            StackTraceElement[] trace = ((Throwable)m).getStackTrace();
            String serialized = m + "\n";
            if (trace != null) {
                for (StackTraceElement el : trace) {
                    serialized = serialized + String.valueOf(el) + "\n";
                }
            }
            return serialized;
        }
        return m;
    }

    protected void writeLog(StringBuilder b, Object object) {
        b.append(String.valueOf(object));
        b.append("\t");
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }
}

