/*
 * Decompiled with CFR 0.152.
 */
package xapi.collect.impl;

import java.util.Iterator;

public class SingletonIterator<X>
implements Iterable<X> {
    private final X singleton;

    public SingletonIterator(X singleton) {
        this.singleton = singleton;
    }

    @Override
    public Iterator<X> iterator() {
        return new Iter(this.singleton);
    }

    private final class Iter
    implements Iterator<X> {
        private X object;

        public Iter(X object) {
            this.object = object;
        }

        @Override
        public boolean hasNext() {
            return this.object != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public X next() {
            try {
                Object x = this.object;
                return x;
            }
            finally {
                this.object = null;
            }
        }

        @Override
        public void remove() {
            this.object = null;
        }
    }
}

