/*
 * Decompiled with CFR 0.152.
 */
package xapi.collect.impl;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import xapi.annotation.inject.InstanceDefault;
import xapi.collect.api.Fifo;

@InstanceDefault(implFor=Fifo.class)
public class SimpleFifo<E>
implements Fifo<E>,
Iterable<E>,
Serializable {
    private static final long serialVersionUID = 2525421548842680240L;
    protected Node head;
    private transient Node tail;
    private int size;

    @Override
    public boolean contains(E item) {
        for (E e : this.forEach()) {
            if (!this.equals(item, e)) continue;
            return true;
        }
        return false;
    }

    public SimpleFifo() {
        this.tail = this.head = new Node();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Fifo<E> give(E item) {
        if (item == null) {
            return this;
        }
        Node add = new Node();
        add.item = item;
        Node node = this.head;
        synchronized (node) {
            ++this.size;
            this.tail.next = add;
            this.tail = add;
        }
        return this;
    }

    @Override
    public void clear() {
        this.head.next = null;
        this.tail = this.head;
        this.size = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(E item) {
        int was;
        Node start = this.head;
        Node next = this.head.next;
        Node node = this.head;
        synchronized (node) {
            was = this.size;
            while (next != null) {
                if (this.equals(next.item, item)) {
                    --this.size;
                    if (next == this.tail) {
                        this.tail = start;
                        this.tail.next = null;
                    } else {
                        start.next = next.next;
                    }
                    next.next = null;
                    next = start.next;
                    continue;
                }
                start = next;
                next = next.next;
            }
        }
        return was > this.size;
    }

    protected boolean equals(E one, E two) {
        return one.equals(two);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E take() {
        Node node = this.head;
        synchronized (node) {
            Node next = this.head.next;
            if (next == null) {
                this.tail = this.head;
                return null;
            }
            --this.size;
            this.head.next = next.next;
            if (next == this.tail) {
                this.tail = this.head;
            }
            Object e = next.item;
            return e;
            finally {
                next.item = null;
            }
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Node node = this.head;
        synchronized (node) {
            this.head.next = null;
            this.tail = null;
        }
    }

    public String toString() {
        return "Fifo [" + this.head.next + " -> " + this.tail + "]";
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public Iterable<E> forEach() {
        return this;
    }

    @Override
    public String join(String delim) {
        Node n = this.head.next;
        if (n == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append(n.item);
        while ((n = n.next) != null) {
            b.append(delim);
            b.append(n.item);
        }
        return b.toString();
    }

    @Override
    public Fifo<E> giveAll(E ... elements) {
        for (E element : elements) {
            this.give(element);
        }
        return this;
    }

    @Override
    public Fifo<E> giveAll(Iterable<E> elements) {
        for (E element : elements) {
            this.give(element);
        }
        return this;
    }

    protected final class Node
    implements Serializable {
        private static final long serialVersionUID = -4821223918445216546L;
        public E item;
        public Node next;

        protected Node() {
        }

        public String toString() {
            return String.valueOf(this.item);
        }
    }

    private class Itr
    implements Iterator<E> {
        Node last;
        Node node;

        private Itr() {
            this.node = this.last = SimpleFifo.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.node.next != null;
        }

        @Override
        public E next() {
            this.last = this.node;
            this.node = this.node.next;
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            return this.node.item;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Node expected = this.node;
            Node node = SimpleFifo.this.head;
            synchronized (node) {
                if (this.last.next != expected) {
                    return;
                }
                if (this.node == SimpleFifo.this.tail) {
                    SimpleFifo.this.tail = this.last;
                }
                if (this.last == this.node) {
                    if (this.last == SimpleFifo.this.head) {
                        throw new IllegalStateException();
                    }
                    return;
                }
                this.last.next = this.node.next;
                this.node.next = null;
                this.node = this.last;
                SimpleFifo.this.size--;
            }
        }
    }
}

