/*
 * Decompiled with CFR 0.152.
 */
package xapi.collect.impl;

import java.io.Serializable;
import java.util.Iterator;
import xapi.collect.api.CharPool;
import xapi.collect.impl.IteratorWrapper;
import xapi.util.impl.Chars;

public class MultithreadedStringTrie<E> {
    private static final char[] emptyString = new char[0];
    protected final Edge root = this.newEdge();

    public void put(char[] key, int start, int end, E value) {
        if (key == null || key.length == 0) {
            this.root.setValue(value);
        } else {
            if (start < 0 || end > key.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.doPut(this.root, key, start, end, value);
        }
    }

    public void put(String key, E value) {
        if (key == null || "".equals(key)) {
            this.root.setValue(value);
        } else {
            this.doPut(this.root, key.toCharArray(), 0, key.length(), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(Edge into, char[] key, int index, int end, E value) {
        int nextIndex;
        Edge nextInto;
        block34: {
            assert (index < end);
            char k = key[index];
            Edge greater = into.greater;
            if (greater != null) {
                assert (into.lesser != null);
                char[] greaterKey = greater.key;
                if (greaterKey.length == 0) {
                    int nextIndex2;
                    Edge nextInto2;
                    if (k - greater.lesser.key[0] >= 0) {
                        this.doPut(greater, key, index, end, value);
                        return;
                    }
                    Edge edge = into;
                    synchronized (edge) {
                        if (greater == into.greater) {
                            Edge lesser = into.lesser;
                            int delta = k - lesser.key[0];
                            if (delta != 0) {
                                Edge newParent = this.newEdge();
                                newParent.greater = into.greater;
                                Edge newNode = this.newEdge(key, index, end, value);
                                if (delta > 0) {
                                    newParent.lesser = newNode;
                                } else {
                                    newParent.lesser = lesser;
                                    into.lesser = newNode;
                                }
                                into.greater = newParent;
                                return;
                            }
                            if (this.insertLesser(into, key, index, end, value)) {
                                return;
                            }
                            nextInto2 = into.lesser;
                            nextIndex2 = index + lesser.key.length;
                        } else {
                            nextInto2 = into;
                            nextIndex2 = index;
                        }
                    }
                    if (nextIndex2 == end) {
                        nextInto2.setValue(value);
                    } else {
                        this.doPut(nextInto2, key, nextIndex2, end, value);
                    }
                    return;
                }
            }
            Edge edge = into;
            synchronized (edge) {
                if (into.lesser == null) {
                    assert (into.greater == null);
                    into.lesser = this.newEdge(key, index, end, value);
                    return;
                }
                char[] lesserKey = into.lesser.key;
                int deltaLesser = k - lesserKey[0];
                if (deltaLesser == 0) {
                    if (this.insertLesser(into, key, index, end, value)) {
                        return;
                    }
                    nextInto = into.lesser;
                    nextIndex = index + lesserKey.length;
                    break block34;
                }
                if (into.greater == null) {
                    Edge newNode = this.newEdge(key, index, end, value);
                    if (deltaLesser < 0) {
                        into.greater = into.lesser;
                        into.lesser = newNode;
                    } else {
                        into.greater = newNode;
                    }
                    return;
                }
                char[] greaterKey = into.greater.key;
                if (greaterKey.length == 0) {
                    nextInto = into;
                    nextIndex = index;
                    break block34;
                }
                if (deltaLesser < 0) {
                    Edge newParent = this.newEdge();
                    Edge newNode = this.newEdge(key, index, end, value);
                    newParent.lesser = into.lesser;
                    newParent.greater = into.greater;
                    into.greater = newParent;
                    into.lesser = newNode;
                    return;
                }
                int deltaGreater = k - greaterKey[0];
                if (deltaGreater == 0) {
                    if (this.insertGreater(into, key, index, end, value)) {
                        return;
                    }
                    nextInto = into.greater;
                    nextIndex = index + into.greater.key.length;
                    break block34;
                }
                Edge newParent = this.newEdge();
                Edge newNode = this.newEdge(key, index, end, value);
                if (deltaGreater > 0) {
                    newParent.greater = newNode;
                    newParent.lesser = into.greater;
                } else {
                    newParent.greater = into.greater;
                    newParent.lesser = newNode;
                }
                into.greater = newParent;
                return;
            }
        }
        if (nextIndex == end) {
            nextInto.setValue(value);
        } else {
            this.doPut(nextInto, key, nextIndex, end, value);
        }
    }

    protected Edge newEdge() {
        return new Edge();
    }

    protected Edge newEdge(char[] key, int index, int end, E value) {
        Edge e = new Edge(key, index, end);
        e.setValue(value);
        return e;
    }

    private boolean insertLesser(Edge into, char[] key, int index, int end, E value) {
        int matchesTo;
        int keyLen = end - index;
        char[] lesserKey = into.lesser.key;
        for (matchesTo = 1; matchesTo < keyLen; ++matchesTo) {
            if (matchesTo == lesserKey.length) {
                return false;
            }
            int delta = key[index + matchesTo] - lesserKey[matchesTo];
            if (delta < 0) {
                into.lesser = this.newEdgeLesser(into.lesser, keyLen, lesserKey, matchesTo, key, index, end, value);
                return true;
            }
            if (delta <= 0) continue;
            into.lesser = this.newEdgeGreater(into.lesser, keyLen, lesserKey, matchesTo, key, index, end, value);
            return true;
        }
        if (matchesTo == lesserKey.length) {
            return false;
        }
        Edge newNode = this.newEdge(key, index, end, value);
        char[] newLesser = new char[lesserKey.length - keyLen];
        System.arraycopy(lesserKey, keyLen, newLesser, 0, newLesser.length);
        newNode.lesser = into.lesser;
        into.lesser = newNode;
        newNode.lesser.key = newLesser;
        return true;
    }

    private boolean insertGreater(Edge into, char[] key, int index, int end, E value) {
        int matchesTo;
        int keyLen = end - index;
        char[] greaterKey = into.greater.key;
        for (matchesTo = 1; matchesTo < keyLen; ++matchesTo) {
            if (matchesTo == greaterKey.length) {
                return false;
            }
            int delta = key[index + matchesTo] - greaterKey[matchesTo];
            if (delta < 0) {
                into.greater = this.newEdgeLesser(into.greater, keyLen, greaterKey, matchesTo, key, index, end, value);
                return true;
            }
            if (delta <= 0) continue;
            into.greater = this.newEdgeGreater(into.greater, keyLen, greaterKey, matchesTo, key, index, end, value);
            return true;
        }
        if (matchesTo == greaterKey.length) {
            return false;
        }
        Edge newNode = this.newEdge(key, index, end, value);
        char[] newGreater = new char[greaterKey.length - keyLen];
        System.arraycopy(greaterKey, keyLen, newGreater, 0, newGreater.length);
        newNode.greater = into.greater;
        into.greater = newNode;
        newNode.greater.key = newGreater;
        return true;
    }

    protected Edge newEdgeLesser(Edge previous, int keyMax, char[] existing, int matchesTo, char[] key, int keyIndex, int keyEnd, E value) {
        char[] newRootKey = new char[matchesTo];
        char[] newExistingKey = new char[existing.length - newRootKey.length];
        char[] newInsertedKey = new char[keyMax - newRootKey.length];
        System.arraycopy(existing, 0, newRootKey, 0, newRootKey.length);
        Edge newRoot = this.newEdge(newRootKey, 0, newRootKey.length, null);
        System.arraycopy(existing, newRootKey.length, newExistingKey, 0, newExistingKey.length);
        previous.key = newExistingKey;
        System.arraycopy(key, keyIndex + newRootKey.length, newInsertedKey, 0, newInsertedKey.length);
        Edge newEdge = this.newEdge(newInsertedKey, 0, newInsertedKey.length, value);
        assert (newRoot.key.length > 0);
        assert (previous.key.length > 0);
        assert (newEdge.key.length > 0);
        newRoot.lesser = newEdge;
        newRoot.greater = previous;
        assert (newEdge.toString().compareTo(previous.toString()) < 0) : "Invalid greaterthan: " + newEdge + " is not < " + previous;
        return newRoot;
    }

    protected Edge newEdgeGreater(Edge previous, int keyMax, char[] existing, int matchesTo, char[] key, int keyIndex, int keyEnd, E value) {
        char[] newRootKey = new char[matchesTo];
        char[] newExistingKey = new char[existing.length - newRootKey.length];
        char[] newInsertedKey = new char[keyMax - newRootKey.length];
        System.arraycopy(existing, 0, newRootKey, 0, newRootKey.length);
        Edge newRoot = this.newEdge(newRootKey, 0, newRootKey.length, null);
        System.arraycopy(existing, newRootKey.length, newExistingKey, 0, newExistingKey.length);
        previous.key = newExistingKey;
        System.arraycopy(key, keyIndex + newRootKey.length, newInsertedKey, 0, newInsertedKey.length);
        Edge newEdge = this.newEdge(newInsertedKey, 0, newInsertedKey.length, value);
        assert (newRoot.key.length > 0);
        assert (previous.key.length > 0);
        assert (newEdge.key.length > 0);
        newRoot.lesser = previous;
        newRoot.greater = newEdge;
        assert (newEdge.toString().compareTo(previous.toString()) > 0);
        return newRoot;
    }

    protected void lock(Edge into, boolean ownsParent) {
    }

    protected void unlock(Edge into, boolean ownsParent) {
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("StringTrie[\n");
        if (this.root.value != null) {
            b.append("\"\" : " + this.root.value + "\n");
        }
        if (this.root.greater != null) {
            this.visit(this.root.greater, 1, new char[0], b);
        }
        if (this.root.lesser != null) {
            this.visit(this.root.lesser, 1, new char[0], b);
        }
        b.append("]");
        return b.toString();
    }

    private void visit(Edge root, int depth, char[] key, StringBuilder b) {
        char[] nextKey;
        boolean anyKey;
        boolean bl = anyKey = key.length > 0;
        if (root.key.length > 0) {
            for (int i = 0; i < depth; ++i) {
                b.append(' ');
            }
            b.append(root.key);
            b.append("\t\t");
            if (root.value == null) {
                b.append("[branch]");
            } else {
                b.append(root.value);
            }
            b.append('\n');
        }
        if (root.lesser != null) {
            char[] childKey = root.lesser.key;
            if (anyKey) {
                nextKey = new char[key.length + childKey.length];
                System.arraycopy(key, 0, nextKey, 0, key.length);
                System.arraycopy(childKey, 0, nextKey, key.length, childKey.length);
                childKey = nextKey;
                nextKey = null;
            }
            this.visit(root.lesser, depth + (anyKey ? 1 : 0), childKey, b);
            childKey = null;
        }
        if (root.greater != null) {
            char[] childKey = root.greater.key;
            if (anyKey) {
                nextKey = new char[key.length + childKey.length];
                System.arraycopy(key, 0, nextKey, 0, key.length);
                System.arraycopy(childKey, 0, nextKey, key.length, childKey.length);
                childKey = nextKey;
                nextKey = null;
            }
            boolean addSpace = anyKey && root.greater.key.length > 0;
            this.visit(root.greater, depth + (addSpace ? 1 : 0), childKey, b);
            childKey = null;
        }
    }

    public E get(String key) {
        if (key == null) {
            return this.get(CharPool.EMPTY_STRING);
        }
        return this.get(new Chars(key.toCharArray()), 0, key.length());
    }

    public E get(char[] key) {
        if (key == null) {
            key = CharPool.EMPTY_STRING;
        }
        return this.get(new Chars(key), 0, key.length);
    }

    public E get(char[] key, int pos, int end) {
        if (key == null) {
            key = CharPool.EMPTY_STRING;
        }
        return this.get(new Chars(key, pos, end), pos, end);
    }

    public E get(Chars keys, int pos, int end) {
        Edge e = this.root;
        while (e != null) {
            block11: {
                if (pos == end) {
                    return this.returnValue(e, keys, pos, end);
                }
                if (e.lesser != null) {
                    char[] lesser = e.lesser.key;
                    for (int i = 0; i < lesser.length; ++i) {
                        if (end <= pos + i) {
                            return this.onEmpty(e, keys, pos, end);
                        }
                        int delta = keys.charAt(pos + i) - lesser[i];
                        if (delta < 0) {
                            return this.onEmpty(e, keys, pos, end);
                        }
                        if (delta <= 0) {
                            continue;
                        }
                        break block11;
                    }
                    e = e.lesser;
                    pos += lesser.length;
                    continue;
                }
            }
            if (e.greater == null) {
                return this.onEmpty(e, keys, pos, end);
            }
            char[] greater = e.greater.key;
            if (greater.length == 0) {
                e = e.greater;
                continue;
            }
            int len = greater.length;
            if (len + pos > end) {
                return this.onEmpty(e, keys, pos, end);
            }
            for (int i = 0; i < len; ++i) {
                if (keys.charAt(pos + i) == greater[i]) continue;
                return this.onEmpty(e, keys, pos, end);
            }
            pos += len;
            e = e.greater;
        }
        return this.onEmpty(e, keys, pos, end);
    }

    public Iterable<E> findPrefixed(String prefix) {
        return new IteratorWrapper(new Itr(prefix));
    }

    public void compress(CharPool charPoolTrie) {
    }

    protected E returnValue(Edge e, Chars keys, int pos, int end) {
        return e.value;
    }

    protected E onEmpty(Edge e, Chars keys, int pos, int end) {
        return null;
    }

    protected class Itr
    implements Iterator<E> {
        Edge next;
        Stack stack;
        E value;

        public Itr(String prefix) {
            this.stack = new Stack(null, null);
            int pos = 0;
            this.next = MultithreadedStringTrie.this.root;
            int m = prefix.length();
            while (pos < m) {
                int match;
                char[] key;
                char k = prefix.charAt(pos);
                if (this.next.lesser != null && k == (key = this.next.lesser.key)[0]) {
                    match = 0;
                    while (++match < key.length) {
                        if (key[pos + match] == key[match]) continue;
                        if (this.next.greater != null) {
                            this.stack = new Stack(this.stack, this.next.greater);
                        }
                        this.next = this.next.lesser;
                        return;
                    }
                    pos += match;
                    this.next = this.next.lesser;
                    continue;
                }
                if (this.next.greater != null) {
                    key = this.next.greater.key;
                    if (key.length == 0) {
                        this.next = this.next.greater;
                        continue;
                    }
                    if (k == key[0]) {
                        match = 0;
                        while (++match < key.length) {
                            if (key[pos + match] == key[match]) continue;
                            this.next = this.next.greater;
                            return;
                        }
                        pos += match;
                        this.next = this.next.greater;
                        continue;
                    }
                }
                this.next = null;
                return;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                return false;
            }
            while (this.stack != null) {
                if (this.next.value != null) {
                    this.value = this.next.value;
                    if (this.next.lesser == null) {
                        if (this.next.greater == null) {
                            this.next = this.stack.value;
                            this.stack = this.stack.next;
                        } else {
                            this.next = this.next.greater;
                        }
                    } else if (this.next.greater == null) {
                        this.next = this.stack.value;
                        this.stack = this.stack.next;
                    } else {
                        this.next = this.next.greater;
                    }
                    return true;
                }
                if (this.next.lesser == null) {
                    assert (this.next.greater == null);
                    this.next = this.stack.value;
                    this.stack = this.stack.next;
                    continue;
                }
                if (this.next.greater != null) {
                    this.stack = new Stack(this.stack, this.next.greater);
                }
                this.next = this.next.lesser;
            }
            return false;
        }

        @Override
        public E next() {
            return this.value;
        }

        @Override
        public void remove() {
        }
    }

    class Stack {
        Stack next;
        Edge value;

        public Stack(Stack stack, Edge value) {
            this.next = stack;
            this.value = value;
        }
    }

    public class Edge
    implements Serializable {
        private static final long serialVersionUID = 5885970862972987462L;
        protected E value;
        protected volatile Edge greater;
        protected volatile Edge lesser;
        protected volatile char[] key;

        protected Edge() {
            this(emptyString, 0, 0);
        }

        public Edge(char[] key, int index, int end) {
            if (index == 0 && end == key.length) {
                this.key = key;
                assert (key == emptyString || end > 0);
            } else {
                this.key = new char[end - index];
                assert (this.key.length > 0);
                System.arraycopy(key, index, this.key, 0, this.key.length);
            }
        }

        protected void setValue(E value) {
            this.value = value;
        }

        public String toString() {
            return new String(this.key);
        }
    }
}

