/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.xapi.dev.source;

import com.google.gwt.thirdparty.xapi.dev.source.ClassBuffer;
import com.google.gwt.thirdparty.xapi.dev.source.ImportSection;
import com.google.gwt.thirdparty.xapi.dev.source.PrintBuffer;
import com.google.gwt.thirdparty.xapi.dev.source.TypeDefinitionException;

public class SourceBuilder<Payload> {
    private final PrintBuffer head = this.buffer = new PrintBuffer();
    private PrintBuffer buffer;
    private ImportSection imports;
    private ClassBuffer classDef;
    private Payload payload;
    private String pkgName = "";
    private int skip;

    public SourceBuilder() {
    }

    public SourceBuilder(String classDef) {
        this();
        this.setClassDefinition(classDef, classDef.trim().endsWith("{"));
    }

    public PrintBuffer getBuffer() {
        return this.buffer;
    }

    public ClassBuffer getClassBuffer() {
        if (this.classDef == null) {
            throw new TypeDefinitionException("setClassDefinition() has not been called yet.\nIf you are running the template generator, your template does include a //@classDefinition()// declaration,\nor your generator is attempting to access the class definition before it is parsed.");
        }
        return this.classDef;
    }

    public SourceBuilder<Payload> setClassDefinition(String definition, boolean wellFormatted) {
        if (this.classDef == null) {
            this.getImports();
            this.classDef = (ClassBuffer)new ClassBuffer(this).indent();
            this.head.addToEnd(this.classDef);
            this.head.setNotIndent();
            this.addBuffer(new PrintBuffer());
        }
        this.classDef.setDefinition(definition, wellFormatted);
        return this;
    }

    public ImportSection getImports() {
        if (this.imports == null) {
            this.imports = new ImportSection();
        }
        return this.imports;
    }

    public Payload getPayload() {
        return this.payload;
    }

    protected SourceBuilder<Payload> addBuffer(PrintBuffer newBuffer) {
        if (newBuffer == this.buffer) {
            return this;
        }
        this.head.addToEnd(newBuffer);
        this.head.setNotIndent();
        this.buffer = newBuffer;
        return this;
    }

    public SourceBuilder<Payload> setPayload(Payload payload) {
        this.payload = payload;
        return this;
    }

    public String getPackage() {
        return this.pkgName;
    }

    public SourceBuilder<Payload> setPackage(String pkgName) {
        if (pkgName.endsWith(";")) {
            pkgName = pkgName.substring(0, pkgName.length() - 1);
        }
        if (pkgName.startsWith("package ")) {
            pkgName = pkgName.substring(8);
        }
        this.pkgName = pkgName;
        return this;
    }

    public SourceBuilder<Payload> setLinesToSkip(int i) {
        this.skip = i;
        return this;
    }

    public int getLinesToSkip() {
        try {
            int n = this.skip;
            return n;
        }
        finally {
            this.skip = 0;
        }
    }

    public String toString() {
        StringBuilder source = new StringBuilder();
        String body = this.head.toString();
        if (this.pkgName.length() > 0) {
            if (body.trim().startsWith("package")) {
                int ind = body.indexOf(59, body.indexOf("package"));
                body = body.substring(ind + 1);
            }
            source.append("package " + this.pkgName + ";\n\n");
        }
        if (this.imports != null) {
            source.append(this.imports.toString());
        }
        source.append(body);
        return source.toString();
    }

    public String getQualifiedName() {
        return this.getClassBuffer().getQualifiedName();
    }

    public String getSimpleName() {
        return this.getClassBuffer().getSimpleName();
    }

    public void destroy() {
        this.setPayload(null);
        this.head.tail = null;
        this.head.head = null;
        this.buffer = null;
        this.imports = null;
        this.classDef = null;
    }
}

