/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.xapi.dev.source;

import com.google.gwt.thirdparty.xapi.collect.impl.SimpleStack;
import com.google.gwt.thirdparty.xapi.dev.source.FieldBuffer;
import com.google.gwt.thirdparty.xapi.dev.source.MemberBuffer;
import com.google.gwt.thirdparty.xapi.dev.source.MethodBuffer;
import com.google.gwt.thirdparty.xapi.dev.source.PrintBuffer;
import com.google.gwt.thirdparty.xapi.dev.source.SourceBuilder;
import com.google.gwt.thirdparty.xapi.dev.source.TypeDefinitionException;
import com.google.gwt.thirdparty.xapi.source.read.JavaLexer;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.TreeSet;

public class ClassBuffer
extends MemberBuffer<ClassBuffer> {
    protected int privacy;
    private boolean isClass;
    private boolean isAnnotation;
    private boolean isEnum;
    private String superClass;
    private String simpleName;
    private final Set<String> interfaces;
    private final SimpleStack<MethodBuffer> ctors;
    protected SourceBuilder<?> context;
    private boolean isWellFormatted;
    private PrintBuffer prefix;
    private final PrintBuffer classes;
    private final PrintBuffer fields;
    private final PrintBuffer constructors;
    private final PrintBuffer methods;
    private PrintBuffer staticFields;
    private PrintBuffer staticMethods;
    private PrintBuffer staticClasses;
    private final PrintBuffer statics;

    public ClassBuffer() {
        this(new SourceBuilder());
    }

    public ClassBuffer(String indent) {
        this(new SourceBuilder(), indent);
    }

    public ClassBuffer(SourceBuilder<?> context) {
        this(context, "");
    }

    public ClassBuffer(SourceBuilder<?> context, String indent) {
        super(indent);
        this.indent();
        this.context = context;
        this.interfaces = new TreeSet<String>();
        this.ctors = new SimpleStack();
        this.classes = new PrintBuffer();
        this.fields = new PrintBuffer();
        this.constructors = new PrintBuffer();
        this.methods = new PrintBuffer();
        this.statics = new PrintBuffer();
        this.addToEnd(this.statics);
        this.addToEnd(this.classes);
        this.addToEnd(this.fields);
        this.addToEnd(this.constructors);
        this.addToEnd(this.methods);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder(Character.toString('\n'));
        if (this.javaDoc != null && this.javaDoc.isNotEmpty()) {
            b.append(this.javaDoc.toString());
        }
        if (this.annotations.size() > 0) {
            for (String anno : this.annotations) {
                b.append(this.origIndent).append("@").append(anno).append('\n');
            }
        }
        b.append(this.origIndent);
        if (this.prefix != null) {
            b.append(this.prefix);
        }
        if (this.privacy == 1) {
            b.append("public ");
        } else if (this.privacy == 2) {
            b.append("private ");
        } else if (this.privacy == 4) {
            b.append("protected ");
        }
        if (this.isStatic()) {
            b.append("static ");
        }
        if (this.isAbstract()) {
            b.append("abstract ");
        }
        if (this.isFinal()) {
            b.append("final ");
        }
        if (this.isClass) {
            b.append("class ");
        } else {
            if (this.isAnnotation) {
                b.append('@');
            }
            if (this.isEnum) {
                b.append("enum ");
            } else {
                b.append("interface ");
            }
        }
        b.append(this.simpleName + " ");
        if (this.isClass) {
            if (this.superClass != null) {
                b.append("extends " + this.superClass + " ");
            }
            if (this.interfaces.size() > 0) {
                b.append("implements ");
                for (String iface : this.interfaces) {
                    b.append(iface);
                    b.append(", ");
                }
                b.delete(b.length() - 2, b.length() - 1);
            }
        } else if (this.interfaces.size() > 0) {
            if (this.isEnum) {
                b.append("implements ");
            } else {
                b.append("extends ");
            }
            for (String iface : this.interfaces) {
                b.append(iface);
                b.append(", ");
            }
            b.delete(b.length() - 2, b.length());
        }
        if (this.generics.size() > 0) {
            b.append("<");
            for (String generic : this.generics) {
                b.append(generic);
                b.append(", ");
            }
            b.delete(b.length() - 2, b.length());
            b.append("> ");
        }
        b.append("{");
        b.append('\n');
        return b + super.toString();
    }

    protected String superString() {
        return super.toString();
    }

    @Override
    public void addToBeginning(PrintBuffer buffer) {
        if (this.prefix == null) {
            this.prefix = new PrintBuffer();
        }
        this.prefix.addToBeginning(buffer);
    }

    public ClassBuffer setDefinition(String definition, boolean wellFormatted) {
        JavaLexer metadata = new JavaLexer(definition);
        this.isWellFormatted = wellFormatted;
        this.privacy = metadata.getPrivacy();
        if (metadata.isStatic()) {
            this.makeStatic();
        }
        if (metadata.isFinal()) {
            this.makeFinal();
        }
        if (metadata.isAbstract()) {
            this.makeAbstract();
        } else {
            this.makeConcrete();
        }
        this.isClass = metadata.isClass();
        this.isAnnotation = metadata.isAnnotation();
        this.isEnum = metadata.isEnum();
        this.addInterfaces(metadata.getInterfaces());
        this.superClass = metadata.getSuperClass();
        definition = metadata.getClassName();
        this.context.getImports().addImports(metadata.getImports());
        if (metadata.hasGenerics()) {
            String[] generic;
            this.generics.clear();
            for (String s : generic = metadata.getGenerics()) {
                this.generics.add(s);
            }
        }
        if (definition.contains(" ")) {
            throw new TypeDefinitionException("Found ambiguous class definition in " + definition);
        }
        if (definition.length() == 0) {
            throw new TypeDefinitionException("Did not have a class name in class definition " + definition);
        }
        this.simpleName = definition;
        return this;
    }

    public ClassBuffer addInterfaces(String ... interfaces) {
        for (String superInterface : interfaces) {
            this.addInterface(superInterface);
        }
        return this;
    }

    public ClassBuffer addInterface(String iface) {
        return this.addInterface(iface, true);
    }

    public ClassBuffer addInterface(String iface, boolean doImport) {
        int ind;
        iface = iface.trim();
        if (doImport && (ind = iface.indexOf(46)) > 0 && Character.isLowerCase(iface.charAt(0))) {
            iface = this.context.getImports().addImport(iface);
        }
        this.interfaces.add(iface);
        return this;
    }

    public ClassBuffer addInterfaces(Class<?> ... interfaces) {
        for (Class<?> superInterface : interfaces) {
            this.addInterface(superInterface);
        }
        return this;
    }

    public ClassBuffer addInterface(Class<?> iface) {
        assert (iface.isInterface());
        String name = this.context.getImports().addImport(iface.getCanonicalName());
        this.interfaces.add(name);
        return this;
    }

    @Override
    public String addImport(String importName) {
        String stripped;
        if (this.getPackage() == null) {
            throw new NullPointerException("ClassBuffer package not yet set; use .setPackage() on your SourceBuilder for " + this);
        }
        if (importName.startsWith(this.getPackage()) && Character.isUpperCase((stripped = importName.substring(this.getPackage().length() + 1)).charAt(0))) {
            if (this.context.getImports().canMinimize(importName)) {
                this.context.getImports().reserveSimpleName(stripped.substring(stripped.lastIndexOf(46) + 1));
                return stripped;
            }
            return importName;
        }
        return this.context.getImports().addImport(importName);
    }

    @Override
    public String addImport(Class<?> cls) {
        return this.context.getImports().addImport(cls);
    }

    @Override
    public String addImportStatic(Class<?> cls, String name) {
        return this.context.getImports().addStatic(cls, name);
    }

    @Override
    public String addImportStatic(String importName) {
        return this.context.getImports().addStatic(importName);
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public ClassBuffer setSuperClass(String superClass) {
        this.superClass = this.addImport(superClass);
        return this;
    }

    public String getPackage() {
        return this.context.getPackage();
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getQualifiedName() {
        String pkg = this.context.getPackage();
        if (pkg.length() == 0) {
            return this.getSimpleName();
        }
        return pkg + "." + this.getSimpleName();
    }

    public void setSimpleName(String className) {
        this.simpleName = className;
        for (MethodBuffer buffer : this.ctors) {
            buffer.setName(className);
        }
    }

    public ClassBuffer createInnerClass(String classDef) {
        ClassBuffer inner = new ClassBuffer(this.context, this.memberIndent());
        inner.setDefinition(classDef, classDef.trim().endsWith("{"));
        this.addClass(inner);
        return inner;
    }

    public ClassBuffer createAnonymousClass(final String classDef) {
        class AnonymousClass
        extends ClassBuffer {
            public AnonymousClass(SourceBuilder<?> context, String indent) {
                super(context, indent);
            }

            @Override
            public String toString() {
                return '\n' + this.origIndent + "new " + classDef + "() {" + '\n' + this.superString();
            }

            @Override
            protected String memberIndent() {
                return this.indent + "  ";
            }
        }
        AnonymousClass inner = new AnonymousClass(this.context, this.indent + "  ");
        inner.setDefinition(classDef, classDef.trim().endsWith("{"));
        this.addToEnd(inner);
        return inner;
    }

    @Override
    public void addToEnd(PrintBuffer buffer) {
        super.addToEnd(buffer);
        this.setNotIndent();
    }

    protected String memberIndent() {
        return this.origIndent + "  ";
    }

    public MethodBuffer createConstructor(int modifiers, String ... params) {
        MethodBuffer method = new MethodBuffer(this.context, this.memberIndent());
        method.setModifier(modifiers);
        method.setName(this.getSimpleName());
        method.setReturnType("");
        method.addParameters(params);
        this.constructors.addToEnd(method);
        this.ctors.add(method);
        return method;
    }

    public MethodBuffer createMethod(String methodDef) {
        MethodBuffer method = new MethodBuffer(this.context, this.memberIndent());
        method.setDefinition(methodDef);
        this.addMethod(method);
        return method;
    }

    public MethodBuffer createMethod(int modifiers, Class<?> returnType, String name, String ... params) {
        MethodBuffer method = new MethodBuffer(this.context, this.memberIndent());
        method.setModifier(modifiers);
        method.setName(name);
        method.setReturnType(this.addImport(returnType));
        method.addParameters(params);
        this.addMethod(method);
        return method;
    }

    public FieldBuffer createField(Class<?> type, String name) {
        return this.createField(type.getCanonicalName(), name);
    }

    public FieldBuffer createField(Class<?> type, String name, int modifier) {
        FieldBuffer field = new FieldBuffer(this, type.getCanonicalName(), name, this.memberIndent());
        field.setModifier(modifier);
        this.addField(field);
        return field;
    }

    public FieldBuffer createField(String type, String name) {
        FieldBuffer field = new FieldBuffer(this, type, name, this.memberIndent());
        this.addField(field);
        return field;
    }

    public FieldBuffer createField(String type, String name, int modifier) {
        FieldBuffer field = new FieldBuffer(this, type, name, this.memberIndent());
        field.setModifier(modifier);
        this.addField(field);
        return field;
    }

    private void addClass(ClassBuffer clazz) {
        if (Modifier.isStatic(clazz.modifier)) {
            this.staticClasses().addToEnd(clazz);
        } else {
            this.classes.addToEnd(clazz);
        }
    }

    private void addField(FieldBuffer field) {
        if (Modifier.isStatic(field.modifier)) {
            this.staticFields().addToEnd(field);
        } else {
            this.fields.addToEnd(field);
        }
    }

    private void addMethod(MethodBuffer method) {
        if (Modifier.isStatic(method.modifier)) {
            this.staticMethods().addToEnd(method);
        } else {
            this.methods.addToEnd(method);
        }
    }

    private void ensureStatics() {
        if (this.staticFields == null) {
            this.staticFields = new PrintBuffer();
            this.staticClasses = new PrintBuffer();
            this.staticMethods = new PrintBuffer();
            this.statics.addToEnd(this.staticClasses);
            this.statics.addToEnd(this.staticFields);
            this.statics.addToEnd(this.staticMethods);
        }
    }

    private PrintBuffer staticFields() {
        this.ensureStatics();
        return this.staticFields;
    }

    private PrintBuffer staticMethods() {
        this.ensureStatics();
        return this.staticMethods;
    }

    private PrintBuffer staticClasses() {
        this.ensureStatics();
        return this.staticClasses;
    }

    @Override
    protected String footer() {
        return this.isWellFormatted ? "" : "\n" + this.origIndent + "}\n";
    }

    @Override
    public final ClassBuffer makeAbstract() {
        return (ClassBuffer)super.makeAbstract();
    }
}

