/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.xapi.collect.impl;

import java.util.Iterator;

public abstract class AbstractLinkedList<T, N extends Node<T, N>, L extends AbstractLinkedList<T, N, L>>
implements Iterable<T> {
    N tail = this.newNode(null);
    final N head = this.tail;

    public synchronized L add(T item) {
        N node = this.newNode(item);
        ((Node)node).value = item;
        ((Node)this.tail).next = node;
        this.onAdd(this.tail, node);
        this.tail = node;
        return (L)this;
    }

    public synchronized void clear() {
        this.tail = this.head;
        ((Node)this.head).next = null;
    }

    public synchronized L consume(L other) {
        this.onAdd(this.tail, ((AbstractLinkedList)other).head);
        ((Node)this.tail).next = ((Node)((AbstractLinkedList)other).head).next;
        if (((Node)this.tail).next != null) {
            this.tail = ((AbstractLinkedList)other).tail;
        }
        ((AbstractLinkedList)other).tail = ((AbstractLinkedList)other).head;
        ((Node)((AbstractLinkedList)other).head).next = null;
        return (L)this;
    }

    public T head() {
        return ((Node)this.head).next == null ? null : (T)((Node)((Node)this.head).next).value;
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public Iterator<T> iterator() {
        return new NodeIterator();
    }

    public String join(String separator) {
        StringBuilder b = new StringBuilder();
        Iterator<T> iter = this.iterator();
        if (iter.hasNext()) {
            b.append(iter.next());
        }
        while (iter.hasNext()) {
            b.append(separator).append(iter.next());
        }
        return b.toString();
    }

    public T tail() {
        return ((Node)this.tail).value;
    }

    public String toString() {
        return this.getClass().getName() + " [ " + this.join(", ") + " ]";
    }

    protected abstract N newNode(T var1);

    protected void onAdd(N previous, N next) {
    }

    protected final class NodeIterator
    implements Iterator<T> {
        private N next;

        protected NodeIterator() {
            this.next = ((Node)AbstractLinkedList.this.head).next;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            try {
                Object t = ((Node)this.next).value;
                return t;
            }
            finally {
                this.next = ((Node)this.next).next;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class Node<T, N extends Node<T, N>> {
        protected N next;
        protected T value;

        protected Node() {
        }

        public String toString() {
            return "Node [" + this.value + "]";
        }
    }
}

