/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.reflect.shared;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.reflect.shared.ReflectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class JsMemberPool<T>
extends JavaScriptObject {
    public static native int constId(Class<?> var0);

    public static native <T> JsMemberPool<T> createMemberPool(Class<T> var0);

    public static <T> JsMemberPool<T> getMembers(Class<T> cls) {
        int constId = JsMemberPool.constId(cls);
        JsMemberPool<T> members = JsMemberPool.findMembers(constId);
        if (members == null) {
            members = JsMemberPool.createMemberPool(cls);
            JsMemberPool.setMembers(constId, members);
        }
        return members;
    }

    static void addConstructor(Class<?> cls, Constructor c) {
        JsMemberPool<?> pool = JsMemberPool.getMembers(cls);
        pool.addConstructor(c);
    }

    static void addField(Class<?> cls, Field f) {
        JsMemberPool<?> pool = JsMemberPool.getMembers(cls);
        pool.addField(f);
    }

    static void addMethod(Class<?> cls, Method m) {
        JsMemberPool<?> pool = JsMemberPool.getMembers(cls);
        pool.addMethod(m);
    }

    static void addAnnotation(Class<?> cls, Annotation a, boolean declared) {
        JsMemberPool<?> pool = JsMemberPool.getMembers(cls);
        pool.addAnnotation(a, declared);
    }

    static native int getSeedId(Class<?> var0);

    static String getSignature(Class<?> ... signature) {
        StringBuilder key = new StringBuilder();
        for (int i = 0; i < signature.length; ++i) {
            key.append('_');
            key.append(JsMemberPool.constId(signature[i]));
        }
        return key.toString();
    }

    private static Annotation[] annoArray() {
        return new Annotation[0];
    }

    private static Class<?>[] classArray() {
        return new Class[0];
    }

    private static <T> Constructor<T>[] constructorArray() {
        return new Constructor[0];
    }

    private static Field[] fieldArray() {
        return new Field[0];
    }

    private static native void fillConstructors(JsMemberPool<?> var0, Constructor[] var1);

    private static native void fillFields(JsMemberPool<?> var0, Field[] var1);

    private static native void fillMethods(JsMemberPool<?> var0, Method[] var1);

    private static native <T> Constructor<T> findConstructor(JsMemberPool<T> var0, String var1);

    private static native Field findField(JsMemberPool<?> var0, String var1);

    private static native <T> JsMemberPool<T> findMembers(int var0);

    private static native Method findMethod(JsMemberPool<?> var0, String var1);

    private static native boolean isUnique(JavaScriptObject var0, String var1);

    private static Method[] methodArray() {
        return new Method[0];
    }

    private static native <T> void setMembers(int var0, JsMemberPool<T> var1);

    protected JsMemberPool() {
    }

    public final void addAnnotation(Annotation a, boolean declared) {
        this.addAnnotation(a.annotationType().getName(), a, declared);
    }

    public final void addConstructor(Constructor c) {
        this.addConstructor(JsMemberPool.getSignature(c.getParameterTypes()), c);
    }

    public final void addField(Field f) {
        this.addField(f.getName(), f);
    }

    public final void addMethod(Method m) {
        String name = m.getName() + JsMemberPool.getSignature(m.getParameterTypes());
        this.addMethod(name, m);
    }

    public final native <A extends Annotation> A getAnnotation(Class<A> var1);

    public final native Annotation[] getAnnotations();

    public final Class<?>[] getClasses() {
        return this.getType().getClasses();
    }

    public final Constructor<T> getConstructor(Class<?> ... params) throws NoSuchMethodException {
        JsMemberPool<T> pool = this;
        String id = JsMemberPool.getSignature(params);
        Constructor<T> method = JsMemberPool.findConstructor(pool, id);
        if (method == null) {
            pool = pool.getSuperclass();
        } else if (Modifier.isPublic(method.getModifiers())) {
            return method;
        }
        throw new NoSuchMethodException("Could not find public constructor " + this.getType().getSimpleName() + "(" + ReflectUtil.joinClasses(",", params) + ")");
    }

    public final Constructor<T>[] getConstructors() {
        Constructor<T>[] ctors = JsMemberPool.constructorArray();
        JsMemberPool pool = this;
        JavaScriptObject set = JavaScriptObject.createObject();
        for (Constructor<T> declared : pool.getDeclaredConstructors()) {
            if (!Modifier.isPublic(declared.getModifiers()) || !JsMemberPool.isUnique(set, JsMemberPool.getSignature(declared.getParameterTypes()))) continue;
            ctors[ctors.length] = declared;
        }
        return ctors;
    }

    public final native <A extends Annotation> A getDeclaredAnnotation(Class<A> var1);

    public final native Annotation[] getDeclaredAnnotations();

    public final Constructor<T> getDeclaredConstructor(Class<?> ... params) throws NoSuchMethodException {
        String id = JsMemberPool.getSignature(params);
        Constructor<T> ctor = JsMemberPool.findConstructor(this, id);
        if (ctor != null) {
            return ctor;
        }
        throw new NoSuchMethodException("Could not find declared constructor " + this.getType().getSimpleName() + "(" + ReflectUtil.joinClasses(",", params) + ") in " + this.getType());
    }

    public final Constructor<T>[] getDeclaredConstructors() {
        Constructor[] ctors = JsMemberPool.constructorArray();
        JsMemberPool.fillConstructors(this, ctors);
        return ctors;
    }

    public final Field getDeclaredField(String name) throws NoSuchFieldException {
        Field field = JsMemberPool.findField(this, name);
        if (field != null) {
            return field;
        }
        throw new NoSuchFieldException("Could not find declared field " + name + " in " + this.getTypeName());
    }

    public final Field[] getDeclaredFields() {
        Field[] fields = JsMemberPool.fieldArray();
        JsMemberPool.fillFields(this, fields);
        return fields;
    }

    public final Method getDeclaredMethod(String name, Class<?> ... params) throws NoSuchMethodException {
        String id = name + JsMemberPool.getSignature(params);
        Method method = JsMemberPool.findMethod(this, id);
        if (method != null) {
            return method;
        }
        throw new NoSuchMethodException("Could not find declared method " + name + "(" + ReflectUtil.joinClasses(",", params) + ") in " + this.getType());
    }

    public final Method[] getDeclaredMethods() {
        Method[] methods = JsMemberPool.methodArray();
        JsMemberPool.fillMethods(this, methods);
        return methods;
    }

    public final Field getField(String name) throws NoSuchFieldException {
        for (JsMemberPool<T> pool = this; pool != null; pool = pool.getSuperclass()) {
            Field field = JsMemberPool.findField(pool, name);
            if (field == null) {
                continue;
            }
            if (!Modifier.isPublic(field.getModifiers())) break;
            return field;
        }
        throw new NoSuchFieldException("Could not find public field " + name + " in " + this.getTypeName());
    }

    public final Field[] getFields() {
        Field[] fields = JsMemberPool.fieldArray();
        JavaScriptObject set = JavaScriptObject.createObject();
        for (JsMemberPool<T> pool = this; pool != null; pool = pool.getSuperclass()) {
            for (Field declared : pool.getDeclaredFields()) {
                if (!Modifier.isPublic(declared.getModifiers()) || !JsMemberPool.isUnique(set, declared.getName())) continue;
                fields[fields.length] = declared;
            }
        }
        return fields;
    }

    public final Class<?>[] getInterfaces() {
        return this.getType().getInterfaces();
    }

    public final Method getMethod(String name, Class<?> ... params) throws NoSuchMethodException {
        String id = name + JsMemberPool.getSignature(params);
        for (JsMemberPool<T> pool = this; pool != null; pool = pool.getSuperclass()) {
            Method method = JsMemberPool.findMethod(pool, id);
            if (method == null) {
                continue;
            }
            if (!Modifier.isPublic(method.getModifiers())) break;
            return method;
        }
        throw new NoSuchMethodException("Could not find public method " + name + "(" + ReflectUtil.joinClasses(",", params) + ") in " + this.getType());
    }

    public final Method[] getMethods() {
        JsMemberPool<T> pool;
        Method[] methods = JsMemberPool.methodArray();
        JavaScriptObject set = JavaScriptObject.createObject();
        JsMemberPool[] all = new JsMemberPool[]{};
        if (pool.getType().isInterface()) {
            all[all.length] = this;
            for (Class<?> iface : pool.getInterfaces()) {
                all[all.length] = JsMemberPool.getMembers(iface);
            }
        } else {
            for (pool = this; pool != null; pool = pool.getSuperclass()) {
                all[all.length] = pool;
            }
        }
        for (JsMemberPool cls : all) {
            for (Method declared : cls.getDeclaredMethods()) {
                if (!Modifier.isPublic(declared.getModifiers()) || !JsMemberPool.isUnique(set, declared.getName() + JsMemberPool.getSignature(declared.getParameterTypes()))) continue;
                methods[methods.length] = declared;
            }
        }
        return methods;
    }

    public final JsMemberPool<? super T> getSuperclass() {
        Class<T> superClass = this.getType().getSuperclass();
        assert (superClass != this.getType());
        return superClass == null ? null : JsMemberPool.getMembers(superClass);
    }

    public final native Class<T> getType();

    public final native String getTypeName();

    private final native void addAnnotation(String var1, Annotation var2, boolean var3);

    private final native void addConstructor(String var1, Constructor var2);

    private final native void addField(String var1, Field var2);

    private final native void addMethod(String var1, Method var2);
}

