/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.reflect.shared;

import com.google.gwt.core.client.MagicMethod;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.reflect.shared.GwtReflectJre;
import com.google.gwt.reflect.shared.ReflectUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class GwtReflect {
    public static Object arrayGet(Object array, int index) {
        if (GWT.isProdMode()) {
            return GwtReflect.jsniGet(array, index);
        }
        return Array.get(array, index);
    }

    public static int arrayLength(Object array) {
        if (GWT.isProdMode()) {
            return GwtReflect.jsniLength(array);
        }
        return Array.getLength(array);
    }

    public static int constId(Class<?> c) {
        return c.hashCode();
    }

    @MagicMethod(documentation="Generated by com.google.gwt.reflect.rebind.injectors.ConstructInjector")
    public static <T> T construct(Class<? extends T> cls, Class<?>[] paramSignature, Object ... params) throws Throwable {
        assert (GwtReflect.isAssignable(paramSignature, params)) : GwtReflect.formatUnassignableError(cls, paramSignature, params);
        try {
            return GwtReflect.makeAccessible(cls.getDeclaredConstructor(paramSignature)).newInstance(params);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public static String escape(String unescaped) {
        if (GWT.isProdMode()) {
            return GwtReflect.nativeEscape(unescaped);
        }
        int extra = 0;
        int n = unescaped.length();
        for (int in = 0; in < n; ++in) {
            switch (unescaped.charAt(in)) {
                case '\u0000': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '\\': {
                    ++extra;
                }
            }
        }
        if (extra == 0) {
            return unescaped;
        }
        char[] oldChars = unescaped.toCharArray();
        char[] newChars = new char[oldChars.length + extra];
        int in = 0;
        int out = 0;
        int n2 = oldChars.length;
        while (in < n2) {
            int c = oldChars[in];
            switch (c) {
                case 0: {
                    newChars[out++] = 92;
                    c = 48;
                    break;
                }
                case 10: {
                    newChars[out++] = 92;
                    c = 110;
                    break;
                }
                case 13: {
                    newChars[out++] = 92;
                    c = 114;
                    break;
                }
                case 34: {
                    newChars[out++] = 92;
                    c = 34;
                    break;
                }
                case 92: {
                    newChars[out++] = 92;
                    c = 92;
                }
            }
            newChars[out] = c;
            ++in;
            ++out;
        }
        return String.valueOf(newChars);
    }

    private static native String nativeEscape(String var0);

    public static <T> T fieldGet(Class<?> cls, String name, Object inst) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = GwtReflect.jvmGetField(cls, name);
        return (T)field.get(inst);
    }

    public static boolean fieldGetBoolean(Class<?> cls, String name, Object inst) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = GwtReflect.jvmGetField(cls, name);
        return field.getBoolean(inst);
    }

    public static byte fieldGetByte(Class<?> cls, String name, Object inst) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = GwtReflect.jvmGetField(cls, name);
        return field.getByte(inst);
    }

    public static char fieldGetChar(Class<?> cls, String name, Object inst) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = GwtReflect.jvmGetField(cls, name);
        return field.getChar(inst);
    }

    public static double fieldGetDouble(Class<?> cls, String name, Object inst) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = GwtReflect.jvmGetField(cls, name);
        return field.getDouble(inst);
    }

    public static float fieldGetFloat(Class<?> cls, String name, Object inst) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = GwtReflect.jvmGetField(cls, name);
        return field.getFloat(inst);
    }

    public static int fieldGetInt(Class<?> cls, String name, Object inst) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = GwtReflect.jvmGetField(cls, name);
        return field.getInt(inst);
    }

    public static long fieldGetLong(Class<?> cls, String name, Object inst) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = GwtReflect.jvmGetField(cls, name);
        return field.getLong(inst);
    }

    public static void fieldGetLong(Class<?> cls, String name, Object inst, long value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = GwtReflect.jvmGetField(cls, name);
        field.setLong(inst, value);
    }

    public static short fieldGetShort(Class<?> cls, String name, Object inst) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = GwtReflect.jvmGetField(cls, name);
        return field.getShort(inst);
    }

    public static void fieldSet(Class<?> cls, String name, Object inst, Object value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = GwtReflect.jvmGetField(cls, name);
        field.set(inst, value);
    }

    public static void fieldSetBoolean(Class<?> cls, String name, Object inst, boolean value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = GwtReflect.jvmGetField(cls, name);
        field.setBoolean(inst, value);
    }

    public static void fieldSetByte(Class<?> cls, String name, Object inst, byte value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = GwtReflect.jvmGetField(cls, name);
        field.setByte(inst, value);
    }

    public static void fieldSetChar(Class<?> cls, String name, Object inst, char value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = GwtReflect.jvmGetField(cls, name);
        field.setChar(inst, value);
    }

    public static void fieldSetDouble(Class<?> cls, String name, Object inst, double value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = GwtReflect.jvmGetField(cls, name);
        field.setDouble(inst, value);
    }

    public static void fieldSetFloat(Class<?> cls, String name, Object inst, float value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = GwtReflect.jvmGetField(cls, name);
        field.setFloat(inst, value);
    }

    public static void fieldSetInt(Class<?> cls, String name, Object inst, int value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = GwtReflect.jvmGetField(cls, name);
        field.setInt(inst, value);
    }

    public static void fieldSetShort(Class<?> cls, String name, Object inst, short value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = GwtReflect.jvmGetField(cls, name);
        field.setShort(inst, value);
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> c, Class<?> ... params) {
        try {
            return GwtReflect.makeAccessible(c.getDeclaredConstructor(params));
        }
        catch (NoSuchMethodException e) {
            GwtReflect.log("Could not retrieve " + c + "(" + ReflectUtil.joinClasses(", ", params), e);
            throw new RuntimeException(e);
        }
    }

    public static <T> Constructor<T>[] getDeclaredConstructors(Class<T> c) {
        return (Constructor[])Constructor[].class.cast(GwtReflect.makeAccessible(c.getDeclaredConstructors()));
    }

    public static Field getDeclaredField(Class<?> c, String name) {
        try {
            return GwtReflect.makeAccessible(c.getDeclaredField(name));
        }
        catch (NoSuchFieldException e) {
            GwtReflect.log("Could not retrieve " + c + "." + name, e);
            throw new RuntimeException(e);
        }
    }

    public static Field[] getDeclaredFields(Class<?> c) {
        return GwtReflect.makeAccessible(c.getDeclaredFields());
    }

    public static Method getDeclaredMethod(Class<?> c, String name, Class<?> ... params) {
        try {
            return GwtReflect.makeAccessible(c.getDeclaredMethod(name, params));
        }
        catch (NoSuchMethodException e) {
            GwtReflect.log("Could not retrieve " + c + "." + name + "(" + ReflectUtil.joinClasses(", ", params), e);
            throw new RuntimeException(e);
        }
    }

    public static Method[] getDeclaredMethods(Class<?> c) {
        return GwtReflect.makeAccessible(c.getDeclaredMethods());
    }

    public static Package getPackage(String name) {
        if (GWT.isProdMode()) {
            return Package.getPackage(name);
        }
        return GwtReflectJre.getPackage(name);
    }

    public static <T> Constructor<T> getPublicConstructor(Class<T> c, Class<?> ... params) {
        try {
            return c.getConstructor(params);
        }
        catch (NoSuchMethodException e) {
            GwtReflect.log("Could not retrieve " + c + "(" + ReflectUtil.joinClasses(", ", params), e);
            throw new RuntimeException(e);
        }
    }

    public static <T> Constructor<T>[] getPublicConstructors(Class<T> c) {
        return (Constructor[])Constructor[].class.cast(c.getConstructors());
    }

    public static Field getPublicField(Class<?> c, String name) {
        try {
            return c.getField(name);
        }
        catch (NoSuchFieldException e) {
            GwtReflect.log("Could not retrieve " + c + "." + name, e);
            throw new RuntimeException(e);
        }
    }

    public static Field[] getPublicFields(Class<?> c) {
        return c.getFields();
    }

    public static Method getPublicMethod(Class<?> c, String name, Class<?> ... params) {
        try {
            return c.getMethod(name, params);
        }
        catch (NoSuchMethodException e) {
            GwtReflect.log("Could not retrieve " + c + "." + name + "(" + ReflectUtil.joinClasses(", ", params), e);
            throw new RuntimeException(e);
        }
    }

    public static Method[] getPublicMethods(Class<?> c) {
        return c.getMethods();
    }

    public static Object invoke(Class<?> cls, String name, Class<?>[] paramTypes, Object inst, Object ... params) throws Throwable {
        Method method;
        assert (GwtReflect.isAssignable(paramTypes, params)) : GwtReflect.formatUnassignableError(cls, paramTypes, params) + " for method named " + name;
        try {
            method = GwtReflect.makeAccessible(cls.getDeclaredMethod(name, paramTypes));
        }
        catch (NoSuchMethodException e) {
            method = cls.getMethod(name, paramTypes);
        }
        try {
            if (!GWT.isScript() && inst == null && method.getDeclaringClass().isInterface() && !Modifier.isAbstract(method.getModifiers())) {
                return GwtReflectJre.invokeDefaultMethod(method, params);
            }
            if (method.getReturnType() == Void.TYPE) {
                method.invoke(inst, params);
                return null;
            }
            return method.invoke(inst, params);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public static native Object jsniGet(Object var0, int var1);

    public static native int jsniLength(Object var0);

    public static <T> Class<T> magicClass(Class<? extends T> cls) {
        assert (cls != null);
        return (Class)Class.class.cast(cls);
    }

    public static <T> T[] newArray(Class<T> classLit, int size) {
        return GwtReflectJre.newArray(classLit, size);
    }

    public static <T> T[][] newArray(Class<T> classLit, int dim1, int dim2) {
        return GwtReflectJre.newArray(classLit, dim1, dim2);
    }

    public static <T extends Throwable> T doThrow(T exception) throws T {
        throw exception;
    }

    private static int assignableDepth(Class<?>[] paramSignature, Object[] params) {
        if (paramSignature.length != params.length) {
            return 0;
        }
        int i = paramSignature.length;
        while (i-- > 0) {
            Class<?> sig = paramSignature[i];
            Object param = params[i];
            if (sig.isPrimitive()) {
                if (param == null) {
                    return i;
                }
                if (sig.getName().equalsIgnoreCase(param.getClass().getSimpleName()) || sig == Integer.TYPE && param instanceof Integer || sig == Character.TYPE && param instanceof Character) continue;
                return i;
            }
            if (sig.isAssignableFrom(param.getClass())) continue;
            return i;
        }
        return -1;
    }

    private static Long boxLong(long l) {
        return new Long(l);
    }

    private static String formatUnassignableError(Class<?> cls, Class<?>[] paramSignature, Object ... params) {
        int depth = GwtReflect.assignableDepth(paramSignature, params);
        return "Unassignable parameter signature for class " + cls.getName() + "; mismatch on parameter " + depth + "\n Signature type was " + paramSignature[depth].getName() + "; object was " + (params[depth] == null ? "null" : " a " + params[depth].getClass().getName() + " : " + params[depth]);
    }

    private static boolean isAssignable(Class<?>[] paramSignature, Object[] params) {
        return GwtReflect.assignableDepth(paramSignature, params) == -1;
    }

    private static Field jvmGetField(Class<?> cls, String name) throws NoSuchFieldException {
        try {
            return GwtReflect.makeAccessible(cls.getDeclaredField(name));
        }
        catch (NoSuchFieldException e0) {
            try {
                return cls.getField(name);
            }
            catch (NoSuchFieldException e1) {
                while (true) {
                    if ((cls = cls.getSuperclass()) == Object.class || cls == null) {
                        throw new NoSuchFieldException("No field " + name + " in " + cls);
                    }
                    try {
                        return GwtReflect.makeAccessible(cls.getDeclaredField(name));
                    }
                    catch (NoSuchFieldException e2) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private static void log(String string, Throwable e) {
        GWT.log(string, e);
    }

    private static <T extends AccessibleObject> T makeAccessible(T member) {
        if (!member.isAccessible()) {
            member.setAccessible(true);
        }
        return member;
    }

    private static <T extends AccessibleObject> T[] makeAccessible(T[] members) {
        for (T member : members) {
            GwtReflect.makeAccessible(member);
        }
        return members;
    }

    private static void nullCheck(Object o) {
        if (o == null) {
            throw new NullPointerException("Null is not allowed");
        }
    }

    private static long unboxLong(Number l) {
        return l.longValue();
    }

    private GwtReflect() {
    }
}

