/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.quantile;

import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import cern.jet.random.engine.RandomEngine;
import hep.aida.bin.DynamicBin1D;
import hep.aida.bin.QuantileBin1D;
import java.text.DecimalFormat;
import java.util.Date;

public class Quantile1Test {
    public static void main(String[] stringArray) {
        int n = 0;
        try {
            n = Integer.parseInt(stringArray[0]);
        }
        catch (Exception exception) {
            System.err.println("Unable to parse input line count argument");
            System.err.println(exception.getMessage());
            System.exit(1);
        }
        System.out.println("Got numExamples=" + n);
        long l = 0L;
        try {
            l = stringArray[1].equals("L") ? Long.MAX_VALUE : (stringArray[1].equals("I") ? Integer.MAX_VALUE : Long.parseLong(stringArray[1]));
        }
        catch (Exception exception) {
            System.err.println("Error parsing flag for N");
            System.err.println(exception.getMessage());
            System.exit(1);
        }
        System.out.println("Got N=" + l);
        DRand dRand = new DRand(new Date());
        QuantileBin1D quantileBin1D = new QuantileBin1D(false, l, 1.0E-4, 0.001, 200, (RandomEngine)dRand, false, false, 2);
        DynamicBin1D dynamicBin1D = new DynamicBin1D();
        Uniform uniform = new Uniform(new DRand(7757));
        for (int i = 1; i <= n; ++i) {
            double d = uniform.nextDouble();
            quantileBin1D.add(d);
            dynamicBin1D.add(d);
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        System.out.println();
        int n2 = 10;
        for (int i = 1; i < 100; i += n2) {
            double d = (double)i * 0.01;
            double d2 = quantileBin1D.quantile(d);
            System.out.println(decimalFormat.format(d) + "  " + d2 + ",  " + dynamicBin1D.quantile(d) + ",  " + (dynamicBin1D.quantile(d) - d2));
        }
    }
}

