/*
 * Decompiled with CFR 0.152.
 */
package cascading.nested.core;

import cascading.flow.FlowProcess;
import cascading.nested.core.NestedBaseOperation;
import cascading.nested.core.NestedCoercibleType;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.operation.OperationException;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.util.Util;
import heretical.pointer.path.BaseNestedPointer;
import heretical.pointer.path.NestedPointer;
import heretical.pointer.path.NestedPointerCompiler;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;

public class NestedGetFunction<Node, Result>
extends NestedBaseOperation<Node, Result, Tuple>
implements Function<Tuple> {
    protected final NestedPointer<Node, Result>[] pointers;
    protected final boolean failOnMissingNode;

    public NestedGetFunction(NestedCoercibleType<Node, Result> nestedCoercibleType, Fields fieldDeclaration, boolean failOnMissingNode, String ... stringPointers) {
        super(nestedCoercibleType, fieldDeclaration);
        this.failOnMissingNode = failOnMissingNode;
        this.verify(stringPointers);
        NestedPointerCompiler compiler = this.getNestedPointerCompiler();
        this.pointers = new BaseNestedPointer[stringPointers.length];
        for (int i = 0; i < stringPointers.length; ++i) {
            this.pointers[i] = compiler.nested(stringPointers[i]);
        }
    }

    protected static String[] asArray(Collection<String> values) {
        return values.toArray(new String[values.size()]);
    }

    protected static Fields asFields(Set<Fields> fields) {
        return fields.stream().reduce(Fields.NONE, Fields::append);
    }

    protected void verify(String[] stringPointers) {
        if (this.getFieldDeclaration().size() != stringPointers.length) {
            throw new IllegalArgumentException("pointers not same length as declared fields");
        }
    }

    public void prepare(FlowProcess flowProcess, OperationCall<Tuple> operationCall) {
        operationCall.setContext((Object)Tuple.size((int)this.pointers.length));
    }

    public void operate(FlowProcess flowProcess, FunctionCall<Tuple> functionCall) {
        Tuple resultTuple = (Tuple)functionCall.getContext();
        Object argument = functionCall.getArguments().getObject(0, this.getCoercibleType());
        this.extractResult(resultTuple, argument);
        functionCall.getOutputCollector().add(resultTuple);
    }

    protected void extractResult(Tuple resultTuple, Node node) {
        this.extractResult((int i, Node result) -> this.setInto(resultTuple, i, result), node);
    }

    protected void setInto(Tuple resultTuple, int i, Node result) {
        Type declaredType = this.getFieldDeclaration().getType(i);
        Object value = this.getCoercibleType().coerce(result, declaredType);
        resultTuple.set(i, value);
    }

    protected void extractResult(Setter<Node> resultSetter, Node node) {
        for (int i = 0; i < this.pointers.length; ++i) {
            Object result = this.pointers[i].at(node);
            if (this.failOnMissingNode && result == null) {
                throw new OperationException("node missing from json node tree: " + this.pointers[i]);
            }
            try {
                resultSetter.set(i, result);
                continue;
            }
            catch (Exception exception) {
                throw new OperationException("value at: " + this.pointers[i] + ", cannot be handled, got: " + Util.truncate((String)result.toString(), (int)25), (Throwable)exception);
            }
        }
    }

    protected static interface Setter<Node> {
        public void set(int var1, Node var2);
    }
}

