/*
 * Decompiled with CFR 0.152.
 */
package cascading.nested.core;

import cascading.flow.FlowProcess;
import cascading.nested.core.NestedCoercibleType;
import cascading.nested.core.NestedGetFunction;
import cascading.operation.FunctionCall;
import cascading.operation.OperationException;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import heretical.pointer.path.NestedPointer;
import heretical.pointer.path.NestedPointerCompiler;

public class NestedGetAllFunction<Node, Result>
extends NestedGetFunction<Node, Result> {
    protected NestedPointer<Node, Result> rootPointer;

    public NestedGetAllFunction(NestedCoercibleType<Node, Result> nestedCoercibleType, String stringRootPointer, Fields fieldDeclaration, boolean failOnMissingNode, String ... stringPointers) {
        super(nestedCoercibleType, fieldDeclaration, failOnMissingNode, stringPointers);
        NestedPointerCompiler compiler = this.getNestedPointerCompiler();
        this.rootPointer = compiler.nested(stringRootPointer);
    }

    @Override
    public void operate(FlowProcess flowProcess, FunctionCall<Tuple> functionCall) {
        Tuple resultTuple = (Tuple)functionCall.getContext();
        Object argument = functionCall.getArguments().getObject(0, this.getCoercibleType());
        Object result = this.rootPointer.allAt(argument);
        if (this.failOnMissingNode && this.getNestedPointerCompiler().size(result) == 0) {
            throw new OperationException("nodes missing from json node tree: " + this.rootPointer);
        }
        Iterable iterable = this.getNestedPointerCompiler().iterable(result);
        for (Object node : iterable) {
            this.extractResult(resultTuple, node);
            functionCall.getOutputCollector().add(resultTuple);
        }
    }
}

