/*
 * Decompiled with CFR 0.152.
 */
package cascading.nested.core;

import cascading.flow.FlowProcess;
import cascading.nested.core.NestedAggregate;
import cascading.nested.core.NestedCoercibleType;
import cascading.nested.core.NestedGetFunction;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.operation.OperationException;
import cascading.operation.SerFunction;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.util.LazyIterable;
import cascading.util.Pair;
import heretical.pointer.path.NestedPointer;
import heretical.pointer.path.NestedPointerCompiler;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class NestedGetAllAggregateFunction<Node, Result>
extends NestedGetFunction<Node, Result> {
    protected final NestedPointer<Node, Result> rootPointer;
    protected final SerFunction<Stream<Node>, Stream<Node>> streamWrapper;
    protected final NestedAggregate<Node, ?>[] nestedAggregates;

    public NestedGetAllAggregateFunction(NestedCoercibleType<Node, Result> nestedCoercibleType, String stringRootPointer, boolean failOnMissingNode, Map<String, NestedAggregate<Node, ?>> pointerMap) {
        this(nestedCoercibleType, stringRootPointer, null, failOnMissingNode, pointerMap);
    }

    public NestedGetAllAggregateFunction(NestedCoercibleType<Node, Result> nestedCoercibleType, String stringRootPointer, SerFunction<Stream<Node>, Stream<Node>> streamWrapper, boolean failOnMissingNode, Map<String, NestedAggregate<Node, ?>> pointerMap) {
        this(nestedCoercibleType, stringRootPointer, streamWrapper, NestedGetAllAggregateFunction.declared(pointerMap.values()), failOnMissingNode, NestedGetAllAggregateFunction.asArray(pointerMap.keySet()), NestedGetAllAggregateFunction.asArrayOf(pointerMap.values()));
    }

    public NestedGetAllAggregateFunction(NestedCoercibleType<Node, Result> nestedCoercibleType, String stringRootPointer, boolean failOnMissingNode, String[] stringPointers, NestedAggregate<Node, ?>[] nestedAggregates) {
        this(nestedCoercibleType, stringRootPointer, null, NestedGetAllAggregateFunction.declared(Arrays.asList(nestedAggregates)), failOnMissingNode, stringPointers, nestedAggregates);
    }

    public NestedGetAllAggregateFunction(NestedCoercibleType<Node, Result> nestedCoercibleType, String stringRootPointer, Fields fieldDeclaration, boolean failOnMissingNode, String[] stringPointers, NestedAggregate<Node, ?>[] nestedAggregates) {
        this(nestedCoercibleType, stringRootPointer, null, fieldDeclaration, failOnMissingNode, stringPointers, nestedAggregates);
    }

    public NestedGetAllAggregateFunction(NestedCoercibleType<Node, Result> nestedCoercibleType, String stringRootPointer, SerFunction<Stream<Node>, Stream<Node>> streamWrapper, boolean failOnMissingNode, String[] stringPointers, NestedAggregate<Node, ?>[] nestedAggregates) {
        this(nestedCoercibleType, stringRootPointer, streamWrapper, NestedGetAllAggregateFunction.declared(Arrays.asList(nestedAggregates)), failOnMissingNode, stringPointers, nestedAggregates);
    }

    public NestedGetAllAggregateFunction(NestedCoercibleType<Node, Result> nestedCoercibleType, String stringRootPointer, SerFunction<Stream<Node>, Stream<Node>> streamWrapper, Fields fieldDeclaration, boolean failOnMissingNode, String[] stringPointers, NestedAggregate<Node, ?>[] nestedAggregates) {
        super(nestedCoercibleType, fieldDeclaration, failOnMissingNode, stringPointers);
        this.streamWrapper = streamWrapper == null ? s -> s : streamWrapper;
        NestedPointerCompiler compiler = this.getNestedPointerCompiler();
        this.rootPointer = compiler.nested(stringRootPointer);
        this.nestedAggregates = nestedAggregates;
    }

    protected static <Node> Fields declared(Collection<NestedAggregate<Node, ?>> nestedAggregates) {
        return nestedAggregates.stream().map(NestedAggregate::getFieldDeclaration).reduce(Fields.NONE, Fields::append);
    }

    protected static <Node> NestedAggregate[] asArrayOf(Collection<NestedAggregate<Node, ?>> nestedAggregates) {
        return nestedAggregates.toArray(new NestedAggregate[0]);
    }

    @Override
    protected void verify(String[] stringPointers) {
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Tuple> operationCall) {
        Pair[] pairs = new Pair[this.nestedAggregates.length];
        for (int i = 0; i < this.nestedAggregates.length; ++i) {
            pairs[i] = new Pair(this.nestedAggregates[i], this.nestedAggregates[i].createContext(this.nestedCoercibleType));
        }
        LazyIterable tupleIterator = new LazyIterable<Pair<NestedAggregate<Node, Object>, Object>, Tuple>(false, pairs){

            protected Tuple convert(Pair<NestedAggregate<Node, Object>, Object> next) {
                return ((NestedAggregate)next.getLhs()).complete(next.getRhs());
            }
        };
        operationCall.setContext((Object)new Tuple(new Object[]{Tuple.size((int)this.getFieldDeclaration().size()), pairs, tupleIterator}));
    }

    @Override
    public void operate(FlowProcess flowProcess, FunctionCall<Tuple> functionCall) {
        Object argument = functionCall.getArguments().getObject(0, this.getCoercibleType());
        Object result = this.rootPointer.allAt(argument);
        if (this.failOnMissingNode && this.getNestedPointerCompiler().size(result) == 0) {
            throw new OperationException("nodes missing from json node tree at: " + this.rootPointer);
        }
        Tuple resultTuple = (Tuple)((Tuple)functionCall.getContext()).getObject(0);
        Pair[] pairs = (Pair[])((Tuple)functionCall.getContext()).getObject(1);
        LazyIterable tupleIterator = (LazyIterable)((Tuple)functionCall.getContext()).getObject(2);
        for (Pair pair : pairs) {
            pair.setRhs(((NestedAggregate)pair.getLhs()).resetContext(pair.getRhs()));
        }
        this.stream(result).forEach(node -> this.aggregateNode(pairs, node));
        resultTuple.setAll((Iterable)tupleIterator);
        functionCall.getOutputCollector().add(resultTuple);
    }

    protected Stream<Node> stream(Result allAt) {
        return (Stream)this.streamWrapper.apply(StreamSupport.stream(this.iterable(allAt).spliterator(), false));
    }

    protected void aggregateNode(Pair<NestedAggregate<Node, Object>, Object>[] pairs, Node node) {
        this.extractResult((int i, Node value) -> this.setInto(pairs, i, value), node);
    }

    protected <Context> void setInto(Pair<NestedAggregate<Node, Context>, Context>[] pairs, int i, Node result) {
        NestedAggregate nestedAggregate = (NestedAggregate)pairs[i].getLhs();
        Object context = pairs[i].getRhs();
        nestedAggregate.aggregate(context, result);
    }
}

