/*
 * Decompiled with CFR 0.152.
 */
package cascading.nested.core.aggregate;

import cascading.nested.core.NestedAggregate;
import cascading.operation.SerPredicate;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.CoercibleType;
import cascading.tuple.type.CoercionFrom;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class BaseNumberNestedAggregate<Node, Type, Context extends BaseContext<Type, Node>>
implements NestedAggregate<Node, Context> {
    protected Fields fieldDeclaration;
    protected Class<Type> aggregateType;

    protected BaseNumberNestedAggregate() {
    }

    protected BaseNumberNestedAggregate(Fields fieldDeclaration, Class<Type> defaultType) {
        if (!fieldDeclaration.hasTypes()) {
            fieldDeclaration = fieldDeclaration.applyTypeToAll(defaultType);
        }
        this.fieldDeclaration = fieldDeclaration;
        this.aggregateType = fieldDeclaration.getTypeClass(0);
        if (Coercions.asNonPrimitive(this.aggregateType) != Coercions.asNonPrimitive(defaultType)) {
            throw new IllegalArgumentException("fieldDeclaration must declare either " + defaultType.getSimpleName() + " object or primitive type");
        }
    }

    @Override
    public Fields getFieldDeclaration() {
        return this.fieldDeclaration;
    }

    protected boolean returnNullForEmpty() {
        return !this.aggregateType.isPrimitive();
    }

    protected boolean discardNullValues() {
        return !this.aggregateType.isPrimitive();
    }

    @Override
    public void aggregate(Context context, Node node) {
        ((BaseContext)context).aggregate(node);
    }

    @Override
    public Tuple complete(Context context) {
        return ((BaseContext)context).complete();
    }

    @Override
    public Context resetContext(Context context) {
        ((BaseContext)context).reset();
        return context;
    }

    public static abstract class BaseContext<Type, Node> {
        protected final CoercibleType<Node> coercibleType;
        protected final CoercionFrom<Node, Type> to;
        protected final Tuple results;
        protected final SerPredicate<Type> discardValue;
        protected final Supplier<Tuple> complete;
        protected boolean allValuesDiscarded = true;

        public BaseContext(BaseNumberNestedAggregate<Node, Type, BaseContext<Type, Node>> aggregateFunction, CoercibleType<Node> coercibleType) {
            this.coercibleType = coercibleType;
            this.to = coercibleType.to(aggregateFunction.aggregateType);
            this.results = this.createResultTuple(aggregateFunction);
            this.discardValue = aggregateFunction.discardNullValues() ? Objects::isNull : (SerPredicate & Serializable)v -> false;
            this.complete = aggregateFunction.returnNullForEmpty() ? this::nullIfDiscard : this::valueIfDiscard;
        }

        protected Tuple createResultTuple(BaseNumberNestedAggregate<Node, Type, BaseContext<Type, Node>> aggregateFunction) {
            return Tuple.size((int)aggregateFunction.getFieldDeclaration().size());
        }

        protected Tuple valueIfDiscard() {
            this.completeAggregateValue(this.results);
            return this.results;
        }

        protected Tuple nullIfDiscard() {
            if (this.allValuesDiscarded) {
                this.results.setAllTo(null);
            } else {
                this.completeAggregateValue(this.results);
            }
            return this.results;
        }

        public void aggregate(Node node) {
            if (node == null) {
                return;
            }
            Type value = this.coerceFrom(node);
            this.addAggregateValue(value);
        }

        protected Type coerceFrom(Node node) {
            return (Type)this.to.coerce(node);
        }

        protected void addAggregateValue(Type value) {
            if (this.discardValue.test(value)) {
                return;
            }
            this.allValuesDiscarded = false;
            this.aggregateFilteredValue(value);
        }

        protected abstract void aggregateFilteredValue(Type var1);

        public Tuple complete() {
            return this.complete.get();
        }

        protected abstract void completeAggregateValue(Tuple var1);

        public void reset() {
            this.allValuesDiscarded = true;
        }
    }
}

