/*
 * Decompiled with CFR 0.152.
 */
package cascading.nested.core;

import cascading.flow.FlowProcess;
import cascading.nested.core.NestedBaseOperation;
import cascading.nested.core.NestedCoercibleType;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.operation.SerPredicate;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.util.Pair;
import heretical.pointer.path.NestedPointerCompiler;
import heretical.pointer.path.Pointer;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class NestedBaseFunction<Node, Result>
extends NestedBaseOperation<Node, Result, Context>
implements Function<Context> {
    protected String rootPointer = "";
    protected SerPredicate<?> defaultValueFilter = (SerPredicate & Serializable)v -> true;
    protected Map<Fields, Pointer<Node>> pointers = new LinkedHashMap<Fields, Pointer<Node>>();

    public NestedBaseFunction(NestedCoercibleType<Node, Result> nestedCoercibleType, Fields fieldDeclaration) {
        this(nestedCoercibleType, fieldDeclaration, Collections.emptyMap());
    }

    public NestedBaseFunction(NestedCoercibleType<Node, Result> nestedCoercibleType, Fields fieldDeclaration, SerPredicate<?> defaultValueFilter) {
        this(nestedCoercibleType, fieldDeclaration, defaultValueFilter, Collections.emptyMap());
    }

    public NestedBaseFunction(NestedCoercibleType<Node, Result> nestedCoercibleType, Fields fieldDeclaration, String rootPointer) {
        this(nestedCoercibleType, fieldDeclaration, Collections.emptyMap());
        if (rootPointer != null) {
            this.rootPointer = rootPointer;
        }
    }

    public NestedBaseFunction(NestedCoercibleType<Node, Result> nestedCoercibleType, Fields fieldDeclaration, String rootPointer, SerPredicate<?> defaultValueFilter) {
        this(nestedCoercibleType, fieldDeclaration, defaultValueFilter, Collections.emptyMap());
        if (rootPointer != null) {
            this.rootPointer = rootPointer;
        }
    }

    public NestedBaseFunction(NestedCoercibleType<Node, Result> nestedCoercibleType, Fields fieldDeclaration, Map<Fields, String> pointerMap) {
        this(nestedCoercibleType, fieldDeclaration, null, pointerMap);
    }

    public NestedBaseFunction(NestedCoercibleType<Node, Result> nestedCoercibleType, Fields fieldDeclaration, SerPredicate<?> defaultValueFilter, Map<Fields, String> pointerMap) {
        super(nestedCoercibleType, fieldDeclaration);
        if (defaultValueFilter != null) {
            this.defaultValueFilter = defaultValueFilter;
        }
        if (pointerMap != null && !pointerMap.isEmpty()) {
            NestedPointerCompiler compiler = this.getNestedPointerCompiler();
            for (Map.Entry<Fields, String> entry : pointerMap.entrySet()) {
                this.pointers.put(entry.getKey(), compiler.compile(entry.getValue()));
            }
        }
    }

    public void prepare(FlowProcess flowProcess, OperationCall<Context> operationCall) {
        LinkedHashMap resolvedPointers = new LinkedHashMap();
        Fields argumentFields = operationCall.getArgumentFields();
        for (Map.Entry<Fields, Pointer<Node>> entry : this.pointers.entrySet()) {
            resolvedPointers.put(argumentFields.select(entry.getKey()), new Pair(this.defaultValueFilter, entry.getValue()));
        }
        if (resolvedPointers.isEmpty()) {
            NestedPointerCompiler compiler = this.getNestedPointerCompiler();
            Iterator iterator = argumentFields.fieldsIterator();
            while (iterator.hasNext()) {
                Fields argument = (Fields)iterator.next();
                Pointer pointer = compiler.compile(this.rootPointer + "/" + argument.get(0).toString());
                resolvedPointers.put(argument, new Pair(this.defaultValueFilter, (Object)pointer));
            }
        }
        operationCall.setContext((Object)new Context(resolvedPointers, Tuple.size((int)1)));
    }

    public void operate(FlowProcess flowProcess, FunctionCall<Context> functionCall) {
        Context context = (Context)functionCall.getContext();
        Node node = this.getNode(functionCall.getArguments());
        Set entries = context.pointers.entrySet();
        for (Map.Entry entry : entries) {
            Fields key = entry.getKey();
            SerPredicate predicate = (SerPredicate)entry.getValue().getLhs();
            Pointer pointer = (Pointer)entry.getValue().getRhs();
            Object argumentValue = functionCall.getArguments().getObject((Comparable)key);
            if (!predicate.test(argumentValue)) continue;
            Object result = this.getLiteralNode(argumentValue);
            pointer.set(node, result);
        }
        context.result.set(0, node);
        functionCall.getOutputCollector().add(context.result);
    }

    protected abstract Node getNode(TupleEntry var1);

    protected class Context {
        public Tuple result;
        public Map<Fields, Pair<SerPredicate<?>, Pointer<Node>>> pointers;

        public Context(Map<Fields, Pair<SerPredicate<?>, Pointer<Node>>> pointers, Tuple result) {
            this.result = result;
            this.pointers = pointers;
        }
    }
}

