/*
 * Decompiled with CFR 0.152.
 */
package cascading.nested.core;

import cascading.flow.FlowProcess;
import cascading.nested.core.CopySpec;
import cascading.nested.core.NestedCoercibleType;
import cascading.nested.core.NestedSpecBaseOperation;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.Tuples;
import heretical.pointer.operation.Copier;
import java.util.Map;
import java.util.function.BiConsumer;

public abstract class NestedBaseCopyFunction<Node, Result>
extends NestedSpecBaseOperation<Node, Result, Context>
implements Function<Context> {
    protected Copier<Node, Result> copier;

    public NestedBaseCopyFunction(NestedCoercibleType<Node, Result> nestedCoercibleType, Fields fieldDeclaration, CopySpec ... copySpecs) {
        super(nestedCoercibleType, fieldDeclaration);
        this.copier = new Copier(this.getNestedPointerCompiler(), (heretical.pointer.operation.CopySpec[])copySpecs);
        if (fieldDeclaration.isDefined() && fieldDeclaration.size() != 1) {
            throw new IllegalArgumentException("can only return a single field");
        }
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Context> operationCall) {
        super.prepare(flowProcess, operationCall);
        boolean resetTransform = operationCall.getArgumentFields().size() > (this.isInto() ? 2 : 1);
        Tuple result = Tuple.size((int)1);
        Fields fields = operationCall.getArgumentFields().subtract(Fields.FIRST);
        operationCall.setContext((Object)new Context(this, resetTransform, result, fields));
    }

    public void operate(FlowProcess flowProcess, FunctionCall<Context> functionCall) {
        Context context = (Context)functionCall.getContext();
        TupleEntry arguments = functionCall.getArguments();
        context.resetTransform.accept(arguments, context.fields);
        Object fromNode = arguments.getObject(0, this.getCoercibleType());
        Object resultNode = this.getResultNode(functionCall);
        this.copier.copy(fromNode, resultNode);
        context.result.set(0, resultNode);
        functionCall.getOutputCollector().add(context.result);
    }

    protected void resetTransforms(TupleEntry arguments, Fields fields) {
        Map values = Tuples.asComparableMap((Fields)fields, (TupleEntry)arguments);
        this.copier.resetTransforms(values);
    }

    protected static class Context {
        public BiConsumer<TupleEntry, Fields> resetTransform = (t, f) -> {};
        public Tuple result;
        public Fields fields;

        public Context(NestedBaseCopyFunction<?, ?> function, boolean resetTransform, Tuple result, Fields fields) {
            if (resetTransform) {
                this.resetTransform = function::resetTransforms;
            }
            this.result = result;
            this.fields = fields;
        }
    }
}

