/*
 * Decompiled with CFR 0.152.
 */
package cascading.nested.core.aggregate;

import cascading.nested.core.aggregate.BaseNumberNestedAggregate;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.type.CoercibleType;
import java.beans.ConstructorProperties;
import java.util.function.Consumer;

public class AverageDoubleNestedAggregate<Node>
extends BaseNumberNestedAggregate<Node, Double, BaseNumberNestedAggregate.BaseContext<Double, Node>> {
    protected final Include include;

    @ConstructorProperties(value={"declaredFields"})
    public AverageDoubleNestedAggregate(Fields declaredFields) {
        this(declaredFields, Include.ALL);
    }

    @ConstructorProperties(value={"declaredFields", "include"})
    public AverageDoubleNestedAggregate(Fields declaredFields, Include include) {
        super(declaredFields, Double.TYPE);
        this.include = include;
    }

    @Override
    protected boolean discardNullValues() {
        return false;
    }

    @Override
    public Context<Node> createContext(CoercibleType<Node> nestedCoercibleType) {
        return new Context<Node>(this, nestedCoercibleType, this.include);
    }

    public static class Context<Node>
    extends BaseNumberNestedAggregate.BaseContext<Double, Node> {
        final Consumer<Double> aggregate;
        int count = 0;
        double sum = 0.0;

        public Context(BaseNumberNestedAggregate<Node, Double, BaseNumberNestedAggregate.BaseContext<Double, Node>> aggregateFunction, CoercibleType<Node> coercibleType, Include include) {
            super(aggregateFunction, coercibleType);
            switch (include) {
                case ALL: {
                    this.aggregate = this::aggregateAll;
                    break;
                }
                case NO_NULLS: {
                    this.aggregate = this::aggregateNoNulls;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown include type, got: " + (Object)((Object)include));
                }
            }
        }

        @Override
        protected void aggregateFilteredValue(Double value) {
            this.aggregate.accept(value);
        }

        protected void aggregateNoNulls(Double value) {
            if (value == null) {
                return;
            }
            ++this.count;
            this.sum += value.doubleValue();
        }

        protected void aggregateAll(Double value) {
            ++this.count;
            if (value == null) {
                return;
            }
            this.sum += value.doubleValue();
        }

        @Override
        protected void completeAggregateValue(Tuple results) {
            results.set(0, (Object)(this.sum / (double)this.count));
        }

        @Override
        public void reset() {
            this.count = 0;
            this.sum = 0.0;
            super.reset();
        }
    }

    public static enum Include {
        ALL,
        NO_NULLS;

    }
}

