/*
 * Decompiled with CFR 0.152.
 */
package cascading.nested.core;

import cascading.flow.FlowProcess;
import cascading.nested.core.NestedBaseOperation;
import cascading.nested.core.NestedCoercibleType;
import cascading.operation.Filter;
import cascading.operation.FilterCall;
import cascading.operation.OperationCall;
import cascading.operation.OperationException;
import heretical.pointer.path.NestedPointer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedRegexFilter<Node, Results>
extends NestedBaseOperation<Node, Results, Matcher[]>
implements Filter<Matcher[]> {
    private static final Logger LOG = LoggerFactory.getLogger(NestedRegexFilter.class);
    private static final String EMPTY = "";
    final NestedPointer<Node, Results> pointer;
    final List<Pattern> patterns;
    final boolean failOnMissingNode;

    public NestedRegexFilter(NestedCoercibleType<Node, Results> nestedCoercibleType, String pointer, List<Pattern> patterns, boolean failOnMissingNode) {
        super(nestedCoercibleType);
        this.pointer = this.getNestedPointerCompiler().nested(pointer);
        this.patterns = new ArrayList<Pattern>(patterns);
        this.failOnMissingNode = failOnMissingNode;
    }

    public void prepare(FlowProcess flowProcess, OperationCall<Matcher[]> operationCall) {
        Matcher[] matchers = new Matcher[this.patterns.size()];
        for (int i = 0; i < this.patterns.size(); ++i) {
            matchers[i] = this.patterns.get(i).matcher(EMPTY);
        }
        operationCall.setContext((Object)matchers);
    }

    public boolean isRemove(FlowProcess flowProcess, FilterCall<Matcher[]> filterCall) {
        Object node = filterCall.getArguments().getObject(0, this.getCoercibleType());
        Object results = this.pointer.allAt(node);
        if (this.size(results) == 0) {
            if (this.failOnMissingNode) {
                throw new OperationException("node missing from json node tree: " + this.pointer);
            }
            for (Matcher matcher : (Matcher[])filterCall.getContext()) {
                matcher.reset(EMPTY);
                boolean found = matcher.find();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("pointer: {}, pattern: {}, matches: {}, on empty string, no json node found with ", new Object[]{this.pointer, matcher.pattern().pattern(), found});
                }
                if (!found) continue;
                return false;
            }
            return true;
        }
        Iterable iterable = this.iterable(results);
        for (Object result : iterable) {
            String value = (String)this.getCoercibleType().coerce(result, String.class);
            if (value == null) {
                value = EMPTY;
            }
            for (Matcher matcher : (Matcher[])filterCall.getContext()) {
                matcher.reset(value);
                boolean found = matcher.find();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("pointer: {}, pattern: {}, matches: {}, element: {}", new Object[]{this.pointer, matcher.pattern().pattern(), found, value});
                }
                if (!found) continue;
                return false;
            }
        }
        return true;
    }
}

