/*
 * Decompiled with CFR 0.152.
 */
package cascading.nested.json.local;

import cascading.flow.FlowProcess;
import cascading.nested.json.JSONCoercibleType;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.scheme.local.CompressorScheme;
import cascading.scheme.local.TextLine;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.Properties;

public class JSONTextLine
extends TextLine {
    public static final Fields DEFAULT_FIELDS = new Fields(new Comparable[]{"json"}).applyTypes(new Type[]{JSONCoercibleType.TYPE});
    private ObjectMapper mapper = new ObjectMapper();

    public JSONTextLine() {
        this(DEFAULT_FIELDS);
    }

    public JSONTextLine(Fields fields) {
        this(fields, "UTF-8");
    }

    public JSONTextLine(Fields fields, String charsetName) {
        this(fields, null, charsetName);
    }

    public JSONTextLine(CompressorScheme.Compressor compressor) {
        this(DEFAULT_FIELDS, compressor);
    }

    public JSONTextLine(Fields fields, CompressorScheme.Compressor compressor) {
        this(fields, compressor, "UTF-8");
    }

    public JSONTextLine(Fields fields, CompressorScheme.Compressor compressor, String charsetName) {
        this(null, fields, compressor, charsetName);
    }

    public JSONTextLine(ObjectMapper mapper, Fields fields) {
        this(mapper, fields, "UTF-8");
    }

    public JSONTextLine(ObjectMapper mapper, Fields fields, String charsetName) {
        this(mapper, fields, null, charsetName);
    }

    public JSONTextLine(ObjectMapper mapper, CompressorScheme.Compressor compressor) {
        this(mapper, DEFAULT_FIELDS, compressor);
    }

    public JSONTextLine(ObjectMapper mapper, Fields fields, CompressorScheme.Compressor compressor) {
        this(mapper, fields, compressor, "UTF-8");
    }

    public JSONTextLine(ObjectMapper mapper, Fields fields, CompressorScheme.Compressor compressor, String charsetName) {
        this.mapper.setConfig(this.mapper.getDeserializationConfig().with(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY));
        if (mapper != null) {
            this.mapper = mapper;
        }
        if (fields == null) {
            throw new IllegalArgumentException("fields may not be null");
        }
        if (!fields.isDefined()) {
            throw new IllegalArgumentException("fields argument must declare a single field");
        }
        if (fields.size() != 1) {
            throw new IllegalArgumentException("may only declare a single source/sink field in the fields argument");
        }
        fields = fields.hasTypes() ? fields : fields.applyTypes(new Type[]{new JSONCoercibleType(this.mapper)});
        this.setSinkFields(fields);
        this.setSourceFields(fields);
        this.setCompressor(compressor);
        this.setCharsetName(charsetName);
    }

    public boolean source(FlowProcess<? extends Properties> flowProcess, SourceCall<LineNumberReader, InputStream> sourceCall) throws IOException {
        String line = ((LineNumberReader)sourceCall.getContext()).readLine();
        if (line == null) {
            return false;
        }
        TupleEntry incomingEntry = sourceCall.getIncomingEntry();
        JsonNode jsonNode = null;
        if (!line.isEmpty()) {
            jsonNode = this.mapper.readTree(line);
        }
        incomingEntry.setObject((Comparable)Integer.valueOf(0), (Object)jsonNode);
        return true;
    }

    public void sink(FlowProcess<? extends Properties> flowProcess, SinkCall<PrintWriter, OutputStream> sinkCall) throws IOException {
        JsonNode jsonNode = (JsonNode)sinkCall.getOutgoingEntry().getTuple().getObject(0);
        if (jsonNode == null) {
            ((PrintWriter)sinkCall.getContext()).println();
        } else {
            String string = this.mapper.writeValueAsString((Object)jsonNode);
            ((PrintWriter)sinkCall.getContext()).println(string);
        }
    }

    protected String getBaseFileExtension() {
        return "json";
    }
}

