/*
 * Decompiled with CFR 0.152.
 */
package cascading.nested.json;

import cascading.CascadingTestCase;
import cascading.nested.json.JSONCoercibleType;
import cascading.nested.json.JSONGetAllFunction;
import cascading.nested.json.JSONGetFunction;
import cascading.operation.Function;
import cascading.operation.OperationException;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleListCollector;
import com.fasterxml.jackson.databind.node.TextNode;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.junit.Test;

public class JSONGetAllFunctionTest
extends CascadingTestCase {
    @Test
    public void testGetAll() {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"people\":[ {\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"female\":false,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}},{\"person\":{\"name\":\"Jane Doe\",\"firstName\":\"Jane\",\"lastName\":\"Doe\",\"age\":49,\"female\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}}]}");
        JSONGetAllFunction function = new JSONGetAllFunction("/people/*", new Fields(new Comparable[]{"result"}), new String[]{"/person/name"});
        TupleListCollector result = JSONGetAllFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JSONGetAllFunctionTest.assertEquals((int)2, (int)result.size());
        Iterator iterator = result.iterator();
        Object value = ((Tuple)iterator.next()).getObject(0);
        JSONGetAllFunctionTest.assertNotNull((Object)value);
        JSONGetAllFunctionTest.assertEquals((String)"John Doe", (String)((TextNode)value).textValue());
        value = ((Tuple)iterator.next()).getObject(0);
        JSONGetAllFunctionTest.assertNotNull((Object)value);
        JSONGetAllFunctionTest.assertEquals((String)"Jane Doe", (String)((TextNode)value).textValue());
    }

    @Test
    public void testGetAllCoerced() {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"people\":[ {\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"female\":false,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}},{\"person\":{\"name\":\"Jane Doe\",\"firstName\":\"Jane\",\"lastName\":\"Doe\",\"age\":49,\"female\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}}]}");
        JSONGetAllFunction function = new JSONGetAllFunction("/people/*", new Fields((Comparable)((Object)"result"), String.class), new String[]{"/person/name"});
        TupleListCollector result = JSONGetAllFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JSONGetAllFunctionTest.assertEquals((int)2, (int)result.size());
        Iterator iterator = result.iterator();
        Object value = ((Tuple)iterator.next()).getObject(0);
        JSONGetAllFunctionTest.assertNotNull((Object)value);
        JSONGetAllFunctionTest.assertEquals((Object)"John Doe", (Object)value);
        value = ((Tuple)iterator.next()).getObject(0);
        JSONGetAllFunctionTest.assertNotNull((Object)value);
        JSONGetAllFunctionTest.assertEquals((Object)"Jane Doe", (Object)value);
    }

    @Test
    public void testGetMissingPointer() {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"people\":[ {\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"female\":false,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}},{\"person\":{\"name\":\"Jane Doe\",\"firstName\":\"Jane\",\"lastName\":\"Doe\",\"age\":49,\"female\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}}]}");
        JSONGetAllFunction function = new JSONGetAllFunction("/notpeople/*", new Fields(new Comparable[]{"result"}), new String[]{"/person/foobar"});
        TupleListCollector result = JSONGetAllFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JSONGetAllFunctionTest.assertEquals((int)0, (int)result.size());
    }

    @Test
    public void testGetMissing() {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"people\":[ {\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"female\":false,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}},{\"person\":{\"name\":\"Jane Doe\",\"firstName\":\"Jane\",\"lastName\":\"Doe\",\"age\":49,\"female\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}}]}");
        JSONGetAllFunction function = new JSONGetAllFunction("/people/*", new Fields(new Comparable[]{"result"}), new String[]{"/person/foobar"});
        TupleListCollector result = JSONGetAllFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONGetAllFunctionTest.assertNull((Object)value);
    }

    @Test(expected=OperationException.class)
    public void testGetMissingFail() {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"people\":[ {\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"female\":false,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}},{\"person\":{\"name\":\"Jane Doe\",\"firstName\":\"Jane\",\"lastName\":\"Doe\",\"age\":49,\"female\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}}]}");
        JSONGetFunction function = new JSONGetFunction(new Fields(new Comparable[]{"result"}), true, new String[]{"/person/foobar"});
        JSONGetAllFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
    }

    @Test
    public void testGetAllDescentCoerced() {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"people\":[ {\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"female\":false,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}},{\"person\":{\"name\":\"Jane Doe\",\"firstName\":\"Jane\",\"lastName\":\"Doe\",\"age\":49,\"female\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}}]}");
        JSONGetAllFunction function = new JSONGetAllFunction("/people/**/name", new Fields((Comparable)((Object)"result"), String.class), new String[]{""});
        TupleListCollector result = JSONGetAllFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JSONGetAllFunctionTest.assertEquals((int)2, (int)result.size());
        Iterator iterator = result.iterator();
        Object value = ((Tuple)iterator.next()).getObject(0);
        JSONGetAllFunctionTest.assertNotNull((Object)value);
        JSONGetAllFunctionTest.assertEquals((Object)"John Doe", (Object)value);
        value = ((Tuple)iterator.next()).getObject(0);
        JSONGetAllFunctionTest.assertNotNull((Object)value);
        JSONGetAllFunctionTest.assertEquals((Object)"Jane Doe", (Object)value);
    }
}

